/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingCallableStatement;
import org.apache.commons.dbcp.DelegatingDatabaseMetaData;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingStatement;

public class DelegatingConnection
extends AbandonedTrace
implements Connection {
    protected Connection _conn = null;
    protected boolean _closed = false;

    public DelegatingConnection(Connection connection) {
        this._conn = connection;
    }

    public DelegatingConnection(Connection connection, AbandonedConfig abandonedConfig) {
        super(abandonedConfig);
        this._conn = connection;
    }

    public String toString() {
        String string = null;
        Connection connection = this.getInnermostDelegateInternal();
        if (connection != null) {
            try {
                if (connection.isClosed()) {
                    string = "connection is closed";
                } else {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (databaseMetaData != null) {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(databaseMetaData.getURL());
                        stringBuffer.append(", UserName=");
                        stringBuffer.append(databaseMetaData.getUserName());
                        stringBuffer.append(", ");
                        stringBuffer.append(databaseMetaData.getDriverName());
                        string = stringBuffer.toString();
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = super.toString();
        }
        return string;
    }

    public Connection getDelegate() {
        return this.getDelegateInternal();
    }

    protected Connection getDelegateInternal() {
        return this._conn;
    }

    public boolean innermostDelegateEquals(Connection connection) {
        Connection connection2 = this.getInnermostDelegateInternal();
        if (connection2 == null) {
            return connection == null;
        }
        return connection2.equals(connection);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        Connection connection = this.getInnermostDelegateInternal();
        if (connection == null) {
            return false;
        }
        if (object instanceof DelegatingConnection) {
            DelegatingConnection delegatingConnection = (DelegatingConnection)object;
            return delegatingConnection.innermostDelegateEquals(connection);
        }
        return connection.equals(object);
    }

    public int hashCode() {
        Connection connection = this.getInnermostDelegateInternal();
        if (connection == null) {
            return 0;
        }
        return connection.hashCode();
    }

    public Connection getInnermostDelegate() {
        return this.getInnermostDelegateInternal();
    }

    protected final Connection getInnermostDelegateInternal() {
        Connection connection = this._conn;
        while (connection != null && connection instanceof DelegatingConnection) {
            if (this != (connection = ((DelegatingConnection)connection).getDelegateInternal())) continue;
            return null;
        }
        return connection;
    }

    public void setDelegate(Connection connection) {
        this._conn = connection;
    }

    public void close() throws SQLException {
        this.passivate();
        this._conn.close();
    }

    protected void handleException(SQLException sQLException) throws SQLException {
        throw sQLException;
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        try {
            this._conn.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void commit() throws SQLException {
        this.checkOpen();
        try {
            this._conn.commit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getCatalog();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingDatabaseMetaData(this, this._conn.getMetaData());
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return -1;
        }
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getWarnings();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return false;
        }
    }

    public String nativeSQL(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public boolean isClosed() throws SQLException {
        return this._closed || this._conn.isClosed();
    }

    protected void checkOpen() throws SQLException {
        if (this._closed) {
            if (null != this._conn) {
                String string = "";
                try {
                    string = this._conn.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new SQLException("Connection " + string + " is closed.");
            }
            throw new SQLException("Connection is null.");
        }
    }

    protected void activate() {
        this._closed = false;
        this.setLastUsed();
        if (this._conn instanceof DelegatingConnection) {
            ((DelegatingConnection)this._conn).activate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate() throws SQLException {
        try {
            List list = this.getTrace();
            if (list != null) {
                for (Object e : list) {
                    if (e instanceof Statement) {
                        ((Statement)e).close();
                        continue;
                    }
                    if (!(e instanceof ResultSet)) continue;
                    ((ResultSet)e).close();
                }
                this.clearTrace();
            }
            this.setLastUsed(0L);
            if (this._conn instanceof DelegatingConnection) {
                ((DelegatingConnection)this._conn).passivate();
            }
        }
        finally {
            this._closed = true;
        }
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.getHoldability();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return 0;
        }
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        try {
            this._conn.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        this.checkOpen();
        try {
            return this._conn.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        try {
            this._conn.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingStatement(this, this._conn.createStatement(n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingCallableStatement(this, this._conn.prepareCall(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement(this, this._conn.prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }
}

