/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.pool.KeyedObjectPool;

public class PoolablePreparedStatement
extends DelegatingPreparedStatement
implements PreparedStatement {
    protected KeyedObjectPool _pool = null;
    protected Object _key = null;
    private volatile boolean batchAdded = false;

    public PoolablePreparedStatement(PreparedStatement preparedStatement, Object object, KeyedObjectPool keyedObjectPool, Connection connection) {
        super((DelegatingConnection)connection, preparedStatement);
        this._pool = keyedObjectPool;
        this._key = object;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
    }

    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this._pool.returnObject(this._key, (Object)this);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLNestedException("Cannot close preparedstatement (return to pool failed)", exception);
            }
        }
    }

    protected void activate() throws SQLException {
        this._closed = false;
        if (this._conn != null) {
            this._conn.addTrace(this);
        }
        super.activate();
    }

    protected void passivate() throws SQLException {
        List list;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
        if ((list = this.getTrace()) != null) {
            ResultSet[] resultSetArray = list.toArray(new ResultSet[list.size()]);
            for (int i = 0; i < resultSetArray.length; ++i) {
                resultSetArray[i].close();
            }
            this.clearTrace();
        }
        if (this.batchAdded) {
            this.clearBatch();
        }
        super.passivate();
    }
}

