/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.datasources.PooledConnectionAndInfo;
import org.apache.commons.dbcp.datasources.PooledConnectionManager;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

class CPDSConnectionFactory
implements PoolableObjectFactory,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource _cpds;
    private final String _validationQuery;
    private final boolean _rollbackAfterValidation;
    private final ObjectPool _pool;
    private String _username = null;
    private String _password = null;
    private final Map validatingMap = new HashMap();
    private final WeakHashMap pcMap = new WeakHashMap();

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool objectPool, String string, String string2, String string3) {
        this(connectionPoolDataSource, objectPool, string, false, string2, string3);
    }

    public CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, ObjectPool objectPool, String string, boolean bl, String string2, String string3) {
        this._cpds = connectionPoolDataSource;
        this._pool = objectPool;
        objectPool.setFactory((PoolableObjectFactory)this);
        this._validationQuery = string;
        this._username = string2;
        this._password = string3;
        this._rollbackAfterValidation = bl;
    }

    public ObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject() {
        PooledConnectionAndInfo pooledConnectionAndInfo;
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = this._username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._username, this._password);
            if (pooledConnection == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pooledConnection.addConnectionEventListener(this);
            pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this._username, this._password);
            this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
        return pooledConnectionAndInfo;
    }

    public void destroyObject(Object object) throws Exception {
        if (object instanceof PooledConnectionAndInfo) {
            PooledConnection pooledConnection = ((PooledConnectionAndInfo)object).getPooledConnection();
            pooledConnection.removeConnectionEventListener(this);
            this.pcMap.remove(pooledConnection);
            pooledConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean validateObject(Object object) {
        boolean bl = false;
        if (!(object instanceof PooledConnectionAndInfo)) return false;
        PooledConnection pooledConnection = ((PooledConnectionAndInfo)object).getPooledConnection();
        String string = this._validationQuery;
        if (null == string) return true;
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingMap.put(pooledConnection, null);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            bl = resultSet.next();
            if (!this._rollbackAfterValidation) return bl;
            connection.rollback();
            return bl;
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Throwable throwable) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Throwable throwable) {}
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
            this.validatingMap.remove(pooledConnection);
        }
    }

    public void passivateObject(Object object) {
    }

    public void activateObject(Object object) {
    }

    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingMap.containsKey(pooledConnection)) {
            Object v = this.pcMap.get(pooledConnection);
            if (v == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(v);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.destroyObject(v);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + v);
                    exception2.printStackTrace();
                }
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        Object v = this.pcMap.get(pooledConnection);
        if (v == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(v);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + v);
            exception.printStackTrace();
        }
    }

    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        Object v = this.pcMap.get(pooledConnection);
        if (v == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this._pool.invalidateObject(v);
            this._pool.close();
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error invalidating connection").initCause(exception);
        }
    }

    public synchronized void setPassword(String string) {
        this._password = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePool(String string) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this._username)) {
                return;
            }
        }
        try {
            this._pool.close();
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Error closing connection pool").initCause(exception);
        }
    }
}

