/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import org.apache.commons.dbcp.managed.TransactionContextListener;
import org.apache.commons.dbcp.managed.TransactionRegistry;

public class TransactionContext {
    private final TransactionRegistry transactionRegistry;
    private final WeakReference transactionRef;
    private Connection sharedConnection;

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction) {
        if (transactionRegistry == null) {
            throw new NullPointerException("transactionRegistry is null");
        }
        if (transaction == null) {
            throw new NullPointerException("transaction is null");
        }
        this.transactionRegistry = transactionRegistry;
        this.transactionRef = new WeakReference<Transaction>(transaction);
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    public void setSharedConnection(Connection connection) throws SQLException {
        if (this.sharedConnection != null) {
            throw new IllegalStateException("A shared connection is alredy set");
        }
        Transaction transaction = this.getTransaction();
        try {
            XAResource xAResource = this.transactionRegistry.getXAResource(connection);
            transaction.enlistResource(xAResource);
        }
        catch (RollbackException rollbackException) {
        }
        catch (SystemException systemException) {
            throw (SQLException)new SQLException("Unable to enlist connection the transaction").initCause(systemException);
        }
        this.sharedConnection = connection;
    }

    public void addTransactionContextListener(final TransactionContextListener transactionContextListener) throws SQLException {
        try {
            this.getTransaction().registerSynchronization(new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int n) {
                    transactionContextListener.afterCompletion(TransactionContext.this, n == 3);
                }
            });
        }
        catch (RollbackException rollbackException) {
        }
        catch (Exception exception) {
            throw (SQLException)new SQLException("Unable to register transaction context listener").initCause(exception);
        }
    }

    public boolean isActive() throws SQLException {
        try {
            Transaction transaction = (Transaction)this.transactionRef.get();
            if (transaction == null) {
                return false;
            }
            int n = transaction.getStatus();
            return n == 0 || n == 1;
        }
        catch (SystemException systemException) {
            throw (SQLException)new SQLException("Unable to get transaction status").initCause(systemException);
        }
    }

    private Transaction getTransaction() throws SQLException {
        Transaction transaction = (Transaction)this.transactionRef.get();
        if (transaction == null) {
            throw new SQLException("Unable to enlist connection because the transaction has been garbage collected");
        }
        return transaction;
    }
}

