/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.tar;

import ch.systemsx.cisd.base.unix.Unix;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;

public class Untar
implements Closeable {
    private static final int DEFAULT_BUFFER_SIZE = 131072;
    private final List<TarArchiveEntry> dirEntries = new ArrayList<TarArchiveEntry>();
    private final TarArchiveInputStream in;
    private final byte[] buf;
    private final boolean setOwner;

    public Untar(File tarFile) throws FileNotFoundException {
        this(tarFile, 131072);
    }

    public Untar(File tarFile, int bufferSize) throws FileNotFoundException {
        this.in = new TarArchiveInputStream((InputStream)new FileInputStream(tarFile));
        this.buf = new byte[bufferSize];
        this.setOwner = Unix.isOperational() && Unix.getEuid() == 0;
    }

    public void extract(File rootDirectory) throws IOException {
        TarArchiveEntry entry;
        while ((entry = this.in.getNextTarEntry()) != null) {
            File entryFile = new File(rootDirectory, entry.getName());
            if (entry.isDirectory()) {
                this.dirEntries.add(entry);
                entryFile.mkdirs();
                continue;
            }
            if (entry.isLink()) {
                if (!Unix.isOperational()) continue;
                Unix.createHardLink(entry.getLinkName(), entryFile.getPath());
                continue;
            }
            if (entry.isSymbolicLink()) {
                if (!Unix.isOperational()) continue;
                Unix.createSymbolicLink(entry.getLinkName(), entryFile.getPath());
                continue;
            }
            if (!entry.isFile() || entry.isBlockDevice() || entry.isCharacterDevice() || entry.isFIFO() || entry.isGNULongLinkEntry() || entry.isGNULongNameEntry() || entry.isGNUSparse() || entry.isPaxHeader() || entry.isGlobalPaxHeader()) continue;
            if (!entryFile.getParentFile().exists()) {
                entryFile.getParentFile().mkdirs();
            }
            this.extractFileContent(entryFile);
            this.setFileMetadata(entryFile, entry);
        }
        ListIterator<TarArchiveEntry> it = this.dirEntries.listIterator(this.dirEntries.size());
        while (it.hasPrevious()) {
            entry = it.previous();
            this.setFileMetadata(new File(rootDirectory, entry.getName()), entry);
        }
    }

    private void setFileMetadata(File entryFile, TarArchiveEntry entry) {
        if (Unix.isOperational()) {
            Unix.setAccessMode(entryFile.getPath(), (short)entry.getMode());
            if (this.setOwner) {
                Unix.setOwner(entryFile.getPath(), entry.getUserId(), entry.getGroupId());
            } else if (Unix.getUid() == entry.getUserId() && Unix.getGid() != entry.getGroupId()) {
                Unix.setOwner(entryFile.getPath(), entry.getUserId(), entry.getGroupId());
            }
        }
        entryFile.setLastModified(entry.getModTime().getTime());
    }

    private void extractFileContent(File entryFile) throws FileNotFoundException, IOException {
        int length;
        FileOutputStream out = new FileOutputStream(entryFile);
        while ((length = this.in.read(this.buf)) > 0) {
            out.write(this.buf, 0, length);
        }
        out.close();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        if (args.length != 2) {
            System.err.println("Untar <tarfile> <directory>");
            System.exit(1);
        }
        File tarFile = new File(args[0]);
        File directory = new File(args[1]);
        Untar untar = null;
        try {
            untar = new Untar(tarFile);
            untar.extract(directory);
            untar.close();
        }
        finally {
            if (untar != null) {
                untar.close();
            }
        }
    }
}

