/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.image;

import java.awt.Color;

public class WavelengthColor {
    private static final float NO_GAMMA = 1.0f;
    private static final int MAX_INTENSITY_VALUE = 255;
    private static final int MIN_WAVELENGTH = 380;
    private static final int MAX_WAVELENGTH = 780;

    private static float calcIntensityCorrectionFactor(int wavelength) {
        float factor = wavelength >= 380 && wavelength < 420 ? 0.3f + 0.7f * (float)(wavelength - 380) / 40.0f : (wavelength >= 420 && wavelength <= 700 ? 1.0f : (wavelength > 700 && wavelength <= 780 ? 0.3f + 0.7f * (float)(780 - wavelength) / 80.0f : 0.0f));
        return factor;
    }

    private static int adjust(double value, double factor, double gamma) {
        if (value == 0.0) {
            return 0;
        }
        if (gamma == 1.0) {
            return (int)Math.round(255.0 * Math.pow(value * factor, gamma));
        }
        return (int)Math.round(255.0 * value * factor);
    }

    public static Color getColorForWavelength(int wavelength) {
        return WavelengthColor.getColorForWavelength(wavelength, 1.0f);
    }

    public static Color getColorForWavelength(int wavelength, float gamma) {
        float blue;
        float green;
        float red;
        if (wavelength >= 380 && wavelength <= 440) {
            red = -((float)wavelength - 440.0f) / 60.0f;
            green = 0.0f;
            blue = 1.0f;
        } else if (wavelength > 440 && wavelength <= 490) {
            red = 0.0f;
            green = ((float)wavelength - 440.0f) / 50.0f;
            blue = 1.0f;
        } else if (wavelength > 490 && wavelength <= 510) {
            red = 0.0f;
            green = 1.0f;
            blue = -((float)wavelength - 510.0f) / 20.0f;
        } else if (wavelength > 510 && wavelength <= 580) {
            red = ((float)wavelength - 510.0f) / 70.0f;
            green = 1.0f;
            blue = 0.0f;
        } else if (wavelength > 580 && wavelength <= 645) {
            red = 1.0f;
            green = -((float)wavelength - 645.0f) / 65.0f;
            blue = 0.0f;
        } else if (wavelength > 645 && wavelength <= 780) {
            red = 1.0f;
            green = 0.0f;
            blue = 0.0f;
        } else {
            red = 0.0f;
            green = 0.0f;
            blue = 0.0f;
        }
        double factor = WavelengthColor.calcIntensityCorrectionFactor(wavelength);
        int r = WavelengthColor.adjust(red, factor, gamma);
        int g = WavelengthColor.adjust(green, factor, gamma);
        int b = WavelengthColor.adjust(blue, factor, gamma);
        return new Color(r, g, b);
    }
}

