/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.parser;

import ch.systemsx.cisd.common.parser.ParsingException;

public final class ColumnSizeMismatchException
extends ParsingException {
    private static final long serialVersionUID = 1L;
    private final int headerLength;
    private final String message;

    public ColumnSizeMismatchException(String[] tokens, int lineNumber, int headerLength) {
        super(tokens, lineNumber);
        assert (tokens.length != headerLength) : "Tokens length and header length must be different (otherwise no reason to throw this exception).";
        this.headerLength = headerLength;
        this.message = this.createMessage();
    }

    private final String createMessage() {
        String[] tokens = this.getTokens();
        String moreLessStr = ColumnSizeMismatchException.getMoreOrLessString(tokens, this.headerLength);
        StringBuilder lineStructure = new StringBuilder();
        int i = 0;
        while (i < tokens.length) {
            lineStructure.append(tokens[i]);
            if (i + 1 < tokens.length) {
                lineStructure.append(" <TAB> ");
            }
            ++i;
        }
        lineStructure.append(" <END_OF_LINE>");
        return String.format("Line <%s> has %s columns (%s) than the header (%s):\n  %s", this.getLineNumber(), moreLessStr, String.valueOf(tokens.length), String.valueOf(this.headerLength), lineStructure.toString());
    }

    private static final String getMoreOrLessString(String[] tokens, int headerLength) {
        return tokens.length > headerLength ? "more" : "less";
    }

    @Override
    public final String getMessage() {
        return this.message;
    }
}

