/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.api.server.json.util;

import com.google.common.base.Predicate;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ClassReferences {
    public static Reflections ref = new Reflections("ch", new Scanner[0]);

    /*
     * WARNING - void declaration
     */
    public static Collection<Class<?>> search(Class<?> clazz, Predicate<Class<?>> filter) {
        void var4_7;
        HashSet<Class<Object>> results = new HashSet();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        boolean n2 = false;
        while (var4_7 < n) {
            Method method = methodArray[var4_7];
            ClassReferences.searchIfMethodIsPublic(method, results);
            ++var4_7;
        }
        if (filter != null) {
            HashSet<Class> filteredResults = new HashSet<Class>();
            for (Class clazz2 : results) {
                if (!filter.apply((Object)clazz2)) continue;
                filteredResults.add(clazz2);
            }
            results = filteredResults;
        }
        return results;
    }

    private static void searchIfMethodIsPublic(Method method, Set<Class<?>> handled) {
        if (Modifier.isPublic(method.getModifiers())) {
            handled.addAll(ClassReferences.search(method, handled));
        }
    }

    private static Set<Class<?>> search(Method method, Set<Class<?>> handled) {
        for (Class<?> clazz : ClassReferences.getClassesReferencedBy(method)) {
            ClassReferences.searchIfClassIsInteresting(clazz, handled);
        }
        return handled;
    }

    private static void searchIfClassIsInteresting(Class<?> clazz, Set<Class<?>> handled) {
        if (ClassReferences.interesting(clazz, handled)) {
            handled.add(clazz);
            handled.addAll(ClassReferences.search(clazz, handled));
        }
    }

    private static Set<Class<?>> search(Class<?> clazz, Set<Class<?>> handled) {
        Method[] methodArray = clazz.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            ClassReferences.searchIfMethodIsGetter(method, handled);
            ++n2;
        }
        for (Class subclass : ref.getSubTypesOf(clazz)) {
            ClassReferences.searchIfClassIsInteresting(subclass, handled);
        }
        return handled;
    }

    private static void searchIfMethodIsGetter(Method method, Set<Class<?>> handled) {
        if (method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
            handled.addAll(ClassReferences.search(method, handled));
        }
    }

    private static Set<Class<?>> getClassesReferencedBy(Method method) {
        HashSet references = new HashSet();
        references.add(method.getReturnType());
        references.addAll(Arrays.asList(method.getParameterTypes()));
        references.addAll(ClassReferences.classesFromTypes(method.getGenericReturnType()));
        references.addAll(ClassReferences.classesFromTypes(method.getGenericParameterTypes()));
        HashSet arrayTypes = new HashSet();
        for (Class clazz : references) {
            arrayTypes.add(clazz.getComponentType());
        }
        references.addAll(arrayTypes);
        return references;
    }

    private static boolean interesting(Class<?> clazz, Set<Class<?>> handled) {
        return clazz != null && !clazz.isArray() && !clazz.isAnonymousClass() && !clazz.isPrimitive() && clazz.getPackage().getName().startsWith("ch") && !handled.contains(clazz);
    }

    private static Set<Class<?>> classesFromTypes(Type ... types) {
        HashSet classes = new HashSet();
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            Collection<Type> parameters = ClassReferences.getActualTypeArguments(type);
            classes.addAll(ClassReferences.getClassesFromTypeArguments(parameters));
            ++n2;
        }
        return classes;
    }

    private static Collection<Type> getActualTypeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return new HashSet<Type>(Arrays.asList(((ParameterizedType)type).getActualTypeArguments()));
        }
        return Collections.emptySet();
    }

    private static Collection<Class<?>> getClassesFromTypeArguments(Collection<Type> types) {
        HashSet classes = new HashSet();
        for (Type type : types) {
            classes.addAll(ClassReferences.getClass(type));
        }
        return classes;
    }

    private static Collection<? extends Class<?>> getClass(Type type) {
        String name = type.toString();
        if (name.indexOf("ch.") == -1) {
            return Collections.emptySet();
        }
        if ((name = name.substring(name.indexOf("ch"))).indexOf(">") != -1) {
            name = name.substring(0, name.indexOf(">"));
        }
        try {
            return Collections.singleton(Class.forName(name));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Cannot find class " + name + " from type " + type.toString());
        }
    }
}

