/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.common.io.hierarchical_content;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.tar.Untar;
import ch.systemsx.cisd.openbis.common.io.HierarchicalContentNodeBasedHierarchicalContentNode;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.AbstractHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class TarBasedHierarchicalContent
extends AbstractHierarchicalContent {
    private File packageFile;
    private File extractTo;

    public TarBasedHierarchicalContent(File packageFile) {
        this.packageFile = packageFile;
    }

    @Override
    public IHierarchicalContentNode getRootNode() {
        this.maybeExtract();
        IHierarchicalContentNode root = this.getFileBasedHierarchicalContent().getRootNode();
        return new HierarchicalContentNodeBasedHierarchicalContentNode(root){

            @Override
            public String getName() {
                return "";
            }

            @Override
            public String getParentRelativePath() {
                return null;
            }
        };
    }

    @Override
    public IHierarchicalContentNode getNode(String relativePath) throws IllegalArgumentException {
        this.maybeExtract();
        return this.getFileBasedHierarchicalContent().getNode(relativePath);
    }

    @Override
    public IHierarchicalContentNode tryGetNode(String relativePath) {
        this.maybeExtract();
        return this.getFileBasedHierarchicalContent().tryGetNode(relativePath);
    }

    @Override
    public void close() {
        if (this.extractTo != null && this.extractTo.exists()) {
            FileUtilities.deleteRecursively(this.extractTo);
        }
    }

    private void maybeExtract() {
        if (this.extractTo == null) {
            Untar untar = null;
            try {
                try {
                    File temp = new File(System.getProperty("java.io.tmpdir"));
                    this.extractTo = new File(temp, UUID.randomUUID().toString());
                    this.extractTo.mkdirs();
                    untar = new Untar(this.packageFile);
                    untar.extract(this.extractTo);
                }
                catch (Exception e) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(e);
                }
            }
            finally {
                if (untar != null) {
                    try {
                        untar.close();
                    }
                    catch (IOException e) {
                        throw CheckedExceptionTunnel.wrapIfNecessary(e);
                    }
                }
            }
        }
    }

    private IHierarchicalContent getFileBasedHierarchicalContent() {
        return new DefaultFileBasedHierarchicalContentFactory().asHierarchicalContent(this.extractTo, null);
    }
}

