/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.api.v1;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssBuilder;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetMetadataDTO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class NewDataSetDTOBuilder {
    private final NewDataSetMetadataDTO dataSetMetadata;
    private String dataSetOwnerIdentifier;
    private NewDataSetDTO.DataSetOwnerType dataSetOwnerType = NewDataSetDTO.DataSetOwnerType.EXPERIMENT;
    private File file;

    public NewDataSetDTOBuilder() {
        this.dataSetMetadata = new NewDataSetMetadataDTO();
    }

    public String getDataSetOwnerIdentifier() {
        return this.dataSetOwnerIdentifier == null ? "" : this.dataSetOwnerIdentifier;
    }

    public void setDataSetOwnerIdentifier(String dataSetOwnerIdentifier) {
        this.dataSetOwnerIdentifier = dataSetOwnerIdentifier;
    }

    public NewDataSetDTO.DataSetOwnerType getDataSetOwnerType() {
        return this.dataSetOwnerType;
    }

    public void setDataSetOwnerType(NewDataSetDTO.DataSetOwnerType dataSetOwnerType) {
        this.dataSetOwnerType = dataSetOwnerType;
    }

    public NewDataSetDTO.DataSetOwner getDataSetOwner() {
        return new NewDataSetDTO.DataSetOwner(this.getDataSetOwnerType(), this.getDataSetOwnerIdentifier());
    }

    public NewDataSetMetadataDTO getDataSetMetadata() {
        return this.dataSetMetadata;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public List<FileInfoDssDTO> getFileInfos() {
        try {
            ArrayList<FileInfoDssDTO> fileInfos = new ArrayList<FileInfoDssDTO>();
            if (this.file == null) {
                return fileInfos;
            }
            if (!this.file.exists()) {
                return fileInfos;
            }
            String path = this.file.getCanonicalPath();
            if (!this.file.isDirectory()) {
                path = this.file.getParentFile().getCanonicalPath();
            }
            FileInfoDssBuilder builder = new FileInfoDssBuilder(path, path);
            builder.appendFileInfosForFile(this.file, fileInfos, true);
            return fileInfos;
        }
        catch (IOException e) {
            throw new IOExceptionUnchecked(e);
        }
    }

    public NewDataSetDTO asNewDataSetDTO() {
        String dataSetFolderNameOrNull = this.file.isDirectory() ? this.file.getName() : null;
        return new NewDataSetDTO(this.dataSetMetadata, this.getDataSetOwner(), dataSetFolderNameOrNull, this.getFileInfos());
    }

    public void initializeFromTemplate(NewDataSetDTOBuilder template) {
        NewDataSetDTO.DataSetOwner owner = template.getDataSetOwner();
        this.setDataSetOwnerIdentifier(owner.getIdentifier());
        this.setDataSetOwnerType(owner.getType());
        this.setFile(template.getFile());
        NewDataSetMetadataDTO otherMetadata = template.getDataSetMetadata();
        this.dataSetMetadata.setDataSetTypeOrNull(otherMetadata.tryDataSetType());
        HashMap<String, String> otherProps = new HashMap<String, String>(otherMetadata.getProperties());
        this.dataSetMetadata.setProperties(otherProps);
        this.dataSetMetadata.setUnmodifiableProperties(new HashSet<String>(otherMetadata.getUnmodifiableProperties()));
    }
}

