/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ar.com.hjg.pngj.ImageInfo;
import ar.com.hjg.pngj.ImageLine;
import ar.com.hjg.pngj.ImageLineHelper;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class PngWritingHelper {
    protected final BufferedImage image;
    protected final int cols;
    protected final int rows;
    protected final boolean hasAlpha;
    protected final boolean isGrayscale;
    protected final int bitDepth;

    public static PngWritingHelper createHelper(BufferedImage image) {
        ColorModel colorModel = image.getColorModel();
        int[] componentSize = colorModel.getComponentSize();
        if (componentSize != null) {
            return new NormalPngWritingHelper(image, componentSize[0]);
        }
        if ("loci.formats.gui.Index16ColorModel".equals(colorModel.getClass().getName())) {
            return new Index16PngWritingHelper(image);
        }
        throw new IllegalArgumentException("The image color model does not specify a bit depth for the color channels and is not one of the known special cases.");
    }

    private static boolean isGrayscale(BufferedImage image) {
        return image.getColorModel().getColorSpace().getNumComponents() == 1;
    }

    private PngWritingHelper(BufferedImage image, int bitDepth) {
        this.image = image;
        this.cols = image.getWidth();
        this.rows = image.getHeight();
        this.bitDepth = bitDepth;
        this.hasAlpha = false;
        this.isGrayscale = PngWritingHelper.isGrayscale(image);
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public ImageInfo getImageInfo() {
        ImageInfo imgInfo = new ImageInfo(this.cols, this.rows, this.bitDepth, this.hasAlpha, this.isGrayscale, false);
        return imgInfo;
    }

    public void fillLine(ImageLine imageLine, int row) {
        if (this.isGrayscale) {
            this.fillGrayscaleLine(imageLine, row);
        } else {
            this.fillRGBLine(imageLine, row);
        }
    }

    protected void fillGrayscaleLine(ImageLine imageLine, int row) {
        int col = 0;
        while (col < this.cols) {
            imageLine.scanline[col] = this.image.getRaster().getSample(col, row, 0);
            ++col;
        }
    }

    protected void fillRGBLine(ImageLine imageLine, int row) {
        int col = 0;
        while (col < this.cols) {
            int pixel = this.image.getRGB(col, row);
            ImageLineHelper.setPixelRGB8((ImageLine)imageLine, (int)col, (int)pixel);
            ++col;
        }
    }

    /* synthetic */ PngWritingHelper(BufferedImage bufferedImage, int n, PngWritingHelper pngWritingHelper) {
        this(bufferedImage, n);
    }

    private static class Index16PngWritingHelper
    extends PngWritingHelper {
        private Index16PngWritingHelper(BufferedImage image) {
            super(image, 8, null);
        }

        @Override
        protected void fillRGBLine(ImageLine imageLine, int row) {
            int col = 0;
            while (col < this.cols) {
                WritableRaster raster = this.image.getRaster();
                short[] value = (short[])raster.getDataElements(col, row, null);
                int pixel = value[0] << 8;
                ImageLineHelper.setPixelRGB8((ImageLine)imageLine, (int)col, (int)pixel);
                ++col;
            }
        }
    }

    private static class NormalPngWritingHelper
    extends PngWritingHelper {
        private NormalPngWritingHelper(BufferedImage image, int bitDepth) {
            super(image, bitDepth, null);
        }
    }
}

