/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic;

import ch.systemsx.cisd.openbis.generic.shared.basic.URLMethodWithParameters;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ImageResolutionKind;

public class DatasetImageOverviewUtilities {
    public static final String SERVLET_NAME = "image-overview";
    public static final String PERM_ID_PARAMETER_KEY = "permId";
    public static final String TYPE_PARAMETER_KEY = "type";
    public static final String RESOLUTION_PARAMETER_KEY = "resolution";
    public static final String SESSION_ID_PARAM = "session_id";

    private static final String createLink(String dssBaseURL, String permId, String typeCode, ImageResolutionKind resolution, String sessionId) {
        URLMethodWithParameters ulrWithParameters = new URLMethodWithParameters(String.valueOf(dssBaseURL) + "/" + SERVLET_NAME);
        ulrWithParameters.addParameter(PERM_ID_PARAMETER_KEY, permId);
        ulrWithParameters.addParameter(TYPE_PARAMETER_KEY, typeCode);
        ulrWithParameters.addParameter(RESOLUTION_PARAMETER_KEY, (Object)resolution);
        ulrWithParameters.addParameter(SESSION_ID_PARAM, sessionId);
        return ulrWithParameters.toString();
    }

    public static String createEmbededImageHtml(String dssBaseURL, String permId, String typeCode, String sessionId) {
        String imageURL = DatasetImageOverviewUtilities.createLink(dssBaseURL, permId, typeCode, ImageResolutionKind.SMALL, sessionId);
        String linkURL = DatasetImageOverviewUtilities.createLink(dssBaseURL, permId, typeCode, ImageResolutionKind.NORMAL, sessionId);
        return URLMethodWithParameters.createEmbededImageHtml(imageURL, linkURL, -1, -1);
    }
}

