/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CodeAndLabel
implements Serializable {
    private static final long serialVersionUID = 35L;
    private String label;
    private String code;

    private CodeAndLabel() {
    }

    public CodeAndLabel(String code, String label) {
        this.code = code;
        this.label = label.trim();
    }

    public final String getLabel() {
        return this.label;
    }

    public final String getCode() {
        return this.code;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CodeAndLabel)) {
            return false;
        }
        CodeAndLabel codeAndTitle = (CodeAndLabel)obj;
        return codeAndTitle.code.equals(this.code) && codeAndTitle.label.equals(this.label);
    }

    public int hashCode() {
        return this.code.hashCode() * 37 + this.label.hashCode();
    }

    public String toString() {
        return "<" + this.code + "> " + this.label;
    }

    public static List<String> asLabels(List<CodeAndLabel> codesAndLabels) {
        ArrayList<String> result = new ArrayList<String>();
        for (CodeAndLabel codeAndLabel : codesAndLabels) {
            result.add(codeAndLabel.getLabel());
        }
        return result;
    }

    public static List<String> asCodes(List<CodeAndLabel> codesAndLabels) {
        ArrayList<String> result = new ArrayList<String>();
        for (CodeAndLabel codeAndLabel : codesAndLabels) {
            result.add(codeAndLabel.getCode());
        }
        return result;
    }
}

