/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocationNode;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;

public class DatasetLocationNode
implements IDatasetLocationNode,
Serializable {
    private static final long serialVersionUID = 1L;
    private IDatasetLocation location;
    private TreeMap<String, IDatasetLocationNode> contained = new TreeMap();

    public DatasetLocationNode(IDatasetLocation location) {
        if (location == null) {
            throw new IllegalArgumentException("Location cannot be null");
        }
        this.location = location;
    }

    @Override
    public IDatasetLocation getLocation() {
        return this.location;
    }

    @Override
    public boolean isContainer() {
        return this.location.getDataSetLocation() == null;
    }

    @Override
    public Collection<IDatasetLocationNode> getComponents() {
        return this.contained.values();
    }

    public void addContained(IDatasetLocationNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node cannot be null");
        }
        this.contained.put(node.getLocation().getDataSetCode(), node);
    }
}

