/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicURLEncoder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;

public class LinkDataSetUrl {
    private String externalCode;
    private String urlTemplate;

    public LinkDataSetUrl(String externalCode, String urlTemplate) {
        this.externalCode = externalCode;
        this.urlTemplate = urlTemplate;
    }

    public LinkDataSetUrl(LinkDataSet dataset) {
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset cannot be null");
        }
        this.externalCode = dataset.getExternalCode();
        if (dataset.getExternalDataManagementSystem() != null) {
            this.urlTemplate = dataset.getExternalDataManagementSystem().getUrlTemplate();
        }
    }

    protected String maybeUnescape(String str) {
        return str;
    }

    public String toString() {
        if (this.externalCode != null && this.urlTemplate != null) {
            String anExternalCode = this.maybeUnescape(this.externalCode);
            String aUrlTemplate = this.maybeUnescape(this.urlTemplate);
            return aUrlTemplate.replaceAll(BasicConstant.EXTERNAL_DMS_URL_TEMPLATE_CODE_PATTERN, BasicURLEncoder.encode(anExternalCode));
        }
        return null;
    }
}

