/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.basic.dto;

import ch.systemsx.cisd.base.annotation.JsonObject;
import java.io.Serializable;

@JsonObject(value="MetaprojectIdentifier")
public class MetaprojectIdentifier
implements Serializable {
    private static final long serialVersionUID = 35L;
    public static final String SEPARATOR = "/";
    private String metaprojectOwnerId;
    private String metaprojectName;

    public MetaprojectIdentifier(String metaprojectOwnerId, String metaprojectName) {
        this.setMetaprojectOwnerId(metaprojectOwnerId);
        this.setMetaprojectName(metaprojectName);
    }

    public String getMetaprojectOwnerId() {
        return this.metaprojectOwnerId;
    }

    public String getMetaprojectName() {
        return this.metaprojectName;
    }

    public String format() {
        return SEPARATOR + this.metaprojectOwnerId + SEPARATOR + this.metaprojectName;
    }

    public static MetaprojectIdentifier parse(String str) {
        if (str == null) {
            return null;
        }
        String[] splitted = str.split(SEPARATOR);
        if (splitted.length == 3) {
            return new MetaprojectIdentifier(splitted[1], splitted[2]);
        }
        throw new IllegalArgumentException("Metaproject identifier must have /USER_ID/METAPROJECT_NAME format - was " + str);
    }

    private MetaprojectIdentifier() {
    }

    private void setMetaprojectOwnerId(String metaprojectOwnerId) {
        if (metaprojectOwnerId == null) {
            throw new IllegalArgumentException("Metaproject owner id cannot be null");
        }
        this.metaprojectOwnerId = metaprojectOwnerId;
    }

    private void setMetaprojectName(String metaprojectName) {
        if (metaprojectName == null) {
            throw new IllegalArgumentException("Metaproject name cannot be null");
        }
        this.metaprojectName = metaprojectName;
    }
}

