/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="database_instances")
public final class DatabaseInstancePE
extends AbstractIdAndCodeHolder<DatabaseInstancePE> {
    private static final long serialVersionUID = 35L;
    public static final String SYSTEM_DEFAULT = "SYSTEM_DEFAULT";
    public static final DatabaseInstancePE[] EMPTY_ARRAY = new DatabaseInstancePE[0];
    private transient Long id;
    private Date registrationDate;
    private String code;
    private String uuid;
    private boolean isHomeDatabase;
    private boolean systemDefault;

    private final void setSystemDefault(boolean systemDefault) {
        this.systemDefault = systemDefault;
    }

    public static final boolean isSystemDefault(String code) {
        return SYSTEM_DEFAULT.equals(code);
    }

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public final Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    public final void setCode(String code) {
        this.code = code;
        this.setSystemDefault(DatabaseInstancePE.isSystemDefault(code));
    }

    @Column(name="uuid")
    @NotNull(message="UUID can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Transient
    public final boolean isSystemDefault() {
        return this.systemDefault;
    }

    @Column(name="is_original_source", nullable=false)
    public final boolean isOriginalSource() {
        return this.isHomeDatabase;
    }

    public final void setOriginalSource(boolean isHomeDatabase) {
        this.isHomeDatabase = isHomeDatabase;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @Override
    @Id
    @SequenceGenerator(name="DATABASE_INSTANCE_ID_SEQ", sequenceName="DATABASE_INSTANCE_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="DATABASE_INSTANCE_ID_SEQ")
    public final Long getId() {
        return this.id;
    }

    @Override
    @Column(unique=true)
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regexp="^[A-Z0-9_\\-\\.]+$", flags={Pattern.Flag.CASE_INSENSITIVE}, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    public final String getCode() {
        return this.code;
    }
}

