/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ClassUtils;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@MappedSuperclass
public abstract class EntityTypePE
extends AbstractTypePE {
    private static final long serialVersionUID = 35L;
    private DatabaseInstancePE databaseInstance;
    private Date modificationDate;
    private ScriptPE validationScript;

    @Transient
    public abstract EntityKind getEntityKind();

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="validation_script_id", updatable=true)
    public ScriptPE getValidationScript() {
        return this.validationScript;
    }

    public void setValidationScript(ScriptPE validationScript) {
        this.validationScript = validationScript;
    }

    public static final <T extends EntityTypePE> T createEntityTypePE(EntityKind entityKind) {
        assert (entityKind != null) : "Unspecified entity kind.";
        return (T)((EntityTypePE)ClassUtils.createInstance(entityKind.getTypeClass()));
    }

    @Override
    ToStringBuilder createStringBuilder() {
        ToStringBuilder builder = super.createStringBuilder();
        builder.append("databaseInstance", (Object)this.getDatabaseInstance());
        return builder;
    }

    @Override
    public boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getDatabaseInstance(), "database instance");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EntityTypePE)) {
            return false;
        }
        EntityTypePE that = (EntityTypePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }
}

