/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public final class TimeInterval
implements Serializable {
    private static final long serialVersionUID = 35L;
    private Date from;
    private Date until;

    public TimeInterval() {
    }

    public TimeInterval(Date from, Date until) {
        this.check(from, until);
        this.from = from;
        this.until = until;
    }

    private void check(Date fromDate, Date untilDate) {
        if (fromDate != null && untilDate != null && fromDate.getTime() > untilDate.getTime()) {
            throw new IllegalArgumentException("From date is after until date: " + fromDate + " > " + untilDate);
        }
    }

    public final Date getFrom() {
        return this.from;
    }

    public final void setFrom(Date from) {
        this.check(this.until, from);
        this.from = from;
    }

    public final Date getUntil() {
        return this.until;
    }

    public final void setUntil(Date until) {
        this.check(until, this.from);
        this.until = until;
    }

    public final boolean isInside(Date date) {
        assert (date != null) : "Unspecified date.";
        long time = date.getTime();
        return !(this.from != null && this.from.getTime() > time || this.until != null && time > this.until.getTime());
    }

    public final boolean overlapsWith(TimeInterval timeInterval) {
        assert (timeInterval != null) : "Unspecified time interval.";
        return TimeInterval.isBeforeOrEqual(this.from, timeInterval.getUntil()) && TimeInterval.isBeforeOrEqual(timeInterval.getFrom(), this.until);
    }

    private static final boolean isBeforeOrEqual(Date olderDate, Date youngerDate) {
        return olderDate == null || youngerDate == null || olderDate.getTime() <= youngerDate.getTime();
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TimeInterval)) {
            return false;
        }
        TimeInterval that = (TimeInterval)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)that.from, (Object)this.from);
        builder.append((Object)that.until, (Object)this.until);
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.from);
        builder.append((Object)this.until);
        return builder.toHashCode();
    }

    public final String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

