/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.structured;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.JsonStructuredPropertyConverter;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.XmlStructuredPropertyConverter;
import java.util.List;

public class XmlOrJsonStructuredPropertyConverter
implements IStructuredPropertyConverter {
    private final XmlStructuredPropertyConverter xmlConverter;
    private final JsonStructuredPropertyConverter jsonConverter;
    private final boolean convertToXML;

    public XmlOrJsonStructuredPropertyConverter(XmlStructuredPropertyConverter xmlConverter, JsonStructuredPropertyConverter jsonConverter, boolean convertToXml) {
        this.xmlConverter = xmlConverter;
        this.jsonConverter = jsonConverter;
        this.convertToXML = convertToXml;
    }

    @Override
    public List<IElement> convertToElements(IManagedProperty property) {
        if (this.xmlConverter.canHandle(property)) {
            return this.xmlConverter.convertToElements(property);
        }
        if (this.jsonConverter.canHandle(property)) {
            return this.jsonConverter.convertToElements(property);
        }
        throw new UserFailureException("Illegal managed property value '" + property.getValue() + "'.");
    }

    @Override
    public List<IElement> convertStringToElements(String string) {
        if (this.xmlConverter.canHandle(string)) {
            return this.xmlConverter.convertStringToElements(string);
        }
        if (this.jsonConverter.canHandle(string)) {
            return this.jsonConverter.convertStringToElements(string);
        }
        throw new UserFailureException("Illegal managed property value '" + string + "'.");
    }

    @Override
    public String convertToString(List<IElement> elements) {
        return this.convertToXML ? this.xmlConverter.convertToString(elements) : this.jsonConverter.convertToString(elements);
    }
}

