/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MetaprojectPE;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MetaprojectTranslator {
    public static List<Metaproject> translate(Collection<MetaprojectPE> metaprojectPEs) {
        ArrayList<Metaproject> metaprojects = new ArrayList<Metaproject>(metaprojectPEs.size());
        for (MetaprojectPE metaprojectPE : metaprojectPEs) {
            metaprojects.add(MetaprojectTranslator.translate(metaprojectPE));
        }
        return metaprojects;
    }

    public static Metaproject translate(MetaprojectPE metaprojectPE) {
        Metaproject metaproject = new Metaproject();
        metaproject.setId(metaprojectPE.getId());
        metaproject.setName(metaprojectPE.getName());
        metaproject.setOwnerId(metaprojectPE.getOwner().getUserId());
        metaproject.setDescription(metaprojectPE.getDescription());
        metaproject.setPrivate(metaprojectPE.isPrivate());
        metaproject.setCreationDate(metaprojectPE.getCreationDate());
        return metaproject;
    }

    public static MetaprojectPE translate(Metaproject metaproject, MetaprojectPE metaprojectPE) {
        metaprojectPE.setName(metaproject.getName().toUpperCase());
        metaprojectPE.setDescription(metaproject.getDescription());
        metaprojectPE.setPrivate(true);
        return metaprojectPE;
    }

    public static Map<Long, Set<Metaproject>> translateMetaprojectAssignments(Collection<MetaprojectAssignmentPE> assignments) {
        HashMap<Long, Metaproject> metaprojects = new HashMap<Long, Metaproject>();
        for (MetaprojectAssignmentPE assignment : assignments) {
            Long metaprojectId = assignment.getMetaproject().getId();
            if (metaprojects.containsKey(metaprojectId)) continue;
            metaprojects.put(metaprojectId, MetaprojectTranslator.translate(assignment.getMetaproject()));
        }
        HashMap<Long, Set<Metaproject>> translatedAssignments = new HashMap<Long, Set<Metaproject>>();
        for (MetaprojectAssignmentPE assignment : assignments) {
            Long entityId = MetaprojectTranslator.tryGetEntityId(assignment);
            HashSet<Metaproject> metaprojectsSet = (HashSet<Metaproject>)translatedAssignments.get(entityId);
            if (metaprojectsSet == null) {
                metaprojectsSet = new HashSet<Metaproject>();
                translatedAssignments.put(entityId, metaprojectsSet);
            }
            metaprojectsSet.add((Metaproject)metaprojects.get(assignment.getMetaproject().getId()));
        }
        return translatedAssignments;
    }

    private static final Long tryGetEntityId(MetaprojectAssignmentPE assignment) {
        if (assignment.getExperiment() != null) {
            return assignment.getExperiment().getId();
        }
        if (assignment.getSample() != null) {
            return assignment.getSample().getId();
        }
        if (assignment.getDataSet() != null) {
            return assignment.getDataSet().getId();
        }
        if (assignment.getMaterial() != null) {
            return assignment.getMaterial().getId();
        }
        return null;
    }
}

