/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.googlecode.jsonrpc4j.ExceptionResolver;
import java.util.LinkedList;
import java.util.List;

public class MultipleExceptionResolver
implements ExceptionResolver {
    private List<ExceptionResolver> resolvers = new LinkedList<ExceptionResolver>();

    public MultipleExceptionResolver(ExceptionResolver ... resolvers) {
        ExceptionResolver[] exceptionResolverArray = resolvers;
        int n = resolvers.length;
        int n2 = 0;
        while (n2 < n) {
            ExceptionResolver resolver = exceptionResolverArray[n2];
            this.resolvers.add(resolver);
            ++n2;
        }
    }

    public void addExceptionResolver(ExceptionResolver ExceptionResolver2) {
        this.resolvers.add(ExceptionResolver2);
    }

    @Override
    public Throwable resolveException(ObjectNode response) {
        for (ExceptionResolver resolver : this.resolvers) {
            Throwable resolvedException = resolver.resolveException(response);
            if (resolvedException == null) continue;
            return resolvedException;
        }
        return null;
    }
}

