/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProxyUtil {
    private static final Logger LOGGER = Logger.getLogger(ProxyUtil.class.getName());

    public static Object createCompositeService(ClassLoader classLoader, Object[] services, boolean allowMultipleInheritance) {
        return ProxyUtil.createCompositeService(classLoader, services, null, allowMultipleInheritance);
    }

    /*
     * WARNING - void declaration
     */
    public static Object createCompositeService(ClassLoader classLoader, Object[] services, Class<?>[] serviceInterfaces, boolean allowMultipleInheritance) {
        HashSet interfaces = new HashSet();
        if (serviceInterfaces != null) {
            interfaces.addAll(Arrays.asList(serviceInterfaces));
        } else {
            void var6_9;
            Object[] objectArray = services;
            int n = services.length;
            boolean n2 = false;
            while (var6_9 < n) {
                Object o = objectArray[var6_9];
                interfaces.addAll(Arrays.asList(o.getClass().getInterfaces()));
                ++var6_9;
            }
        }
        final HashMap<Class, Object> serviceMap = new HashMap<Class, Object>();
        for (Class clazz : interfaces) {
            if (serviceMap.containsKey(clazz) && allowMultipleInheritance) continue;
            if (serviceMap.containsKey(clazz)) {
                throw new IllegalArgumentException("Multiple inheritance not allowed " + clazz.getName());
            }
            Object[] objectArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (clazz.isInstance(o)) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Using " + o.getClass().getName() + " for " + clazz.getName());
                    }
                    serviceMap.put(clazz, o);
                    break;
                }
                ++n2;
            }
            if (serviceMap.containsKey(clazz)) continue;
            throw new IllegalArgumentException("None of the provided services implement " + clazz.getName());
        }
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[0]), new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Class<?> clazz = method.getDeclaringClass();
                return method.invoke(serviceMap.get(clazz), args);
            }
        });
    }

    public static <T> T createProxy(ClassLoader classLoader, Class<T> proxyInterface, JsonRpcClient client, Socket socket) throws IOException {
        return ProxyUtil.createProxy(classLoader, proxyInterface, client, socket.getInputStream(), socket.getOutputStream());
    }

    public static <T> T createProxy(ClassLoader classLoader, Class<T> proxyInterface, final JsonRpcClient client, final InputStream ips, final OutputStream ops) {
        return (T)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return client.invokeAndReadResponse(method.getName(), (Object)args, method.getGenericReturnType(), ops, ips);
            }
        });
    }

    public static <T> T createProxy(ClassLoader classLoader, Class<T> proxyInterface, final JsonRpcHttpClient client, final Map<String, String> extraHeaders) {
        return (T)Proxy.newProxyInstance(classLoader, new Class[]{proxyInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return client.invoke(method.getName(), (Object)args, method.getGenericReturnType(), (Map<String, String>)extraHeaders);
            }
        });
    }

    public static <T> T createProxy(ClassLoader classLoader, Class<T> proxyInterface, JsonRpcHttpClient client) {
        return ProxyUtil.createProxy(classLoader, proxyInterface, client, new HashMap<String, String>());
    }
}

