/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j.spring;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.googlecode.jsonrpc4j.JsonRpcClient;
import com.googlecode.jsonrpc4j.JsonRpcHttpClient;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class JsonProxyFactoryBean
extends UrlBasedRemoteAccessor
implements MethodInterceptor,
InitializingBean,
FactoryBean,
ApplicationContextAware {
    private Object proxyObject = null;
    private JsonRpcClient.RequestListener requestListener = null;
    private ObjectMapper objectMapper = null;
    private JsonRpcHttpClient jsonRpcHttpClient = null;
    private Map<String, String> extraHttpHeaders = new HashMap<String, String>();
    private ApplicationContext applicationContext;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.proxyObject = ProxyFactory.getProxy((Class)this.getServiceInterface(), (Interceptor)this);
        if (this.objectMapper == null && this.applicationContext != null && this.applicationContext.containsBean("objectMapper")) {
            this.objectMapper = (ObjectMapper)this.applicationContext.getBean("objectMapper");
        }
        if (this.objectMapper == null && this.applicationContext != null) {
            try {
                this.objectMapper = (ObjectMapper)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, ObjectMapper.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        try {
            this.jsonRpcHttpClient = new JsonRpcHttpClient(this.objectMapper, new URL(this.getServiceUrl()), this.extraHttpHeaders);
            this.jsonRpcHttpClient.setRequestListener(this.requestListener);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> retType = invocation.getMethod().getGenericReturnType() != null ? invocation.getMethod().getGenericReturnType() : invocation.getMethod().getReturnType();
        return this.jsonRpcHttpClient.invoke(invocation.getMethod().getName(), (Object)invocation.getArguments(), (Type)retType, this.extraHttpHeaders);
    }

    public Object getObject() throws Exception {
        return this.proxyObject;
    }

    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setExtraHttpHeaders(Map<String, String> extraHttpHeaders) {
        this.extraHttpHeaders = extraHttpHeaders;
    }

    public void setRequestListener(JsonRpcClient.RequestListener requestListener) {
        this.requestListener = requestListener;
    }
}

