/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.adapters;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javassist.bytecode.AccessFlag;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import javassist.bytecode.Descriptor;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.annotation.Annotation;
import org.reflections.ReflectionsException;
import org.reflections.adapters.MetadataAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistAdapter
implements MetadataAdapter<ClassFile, FieldInfo, MethodInfo> {
    @Override
    public List<FieldInfo> getFields(ClassFile cls) {
        return cls.getFields();
    }

    @Override
    public List<MethodInfo> getMethods(ClassFile cls) {
        return cls.getMethods();
    }

    @Override
    public String getMethodName(MethodInfo method) {
        return method.getName();
    }

    @Override
    public List<String> getParameterNames(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.indexOf("(") + 1, descriptor.lastIndexOf(")"));
        return this.splitDescriptorToTypeNames(descriptor);
    }

    @Override
    public List<String> getClassAnnotationNames(ClassFile aClass) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)aClass.getAttribute("RuntimeVisibleAnnotations");
        return this.getAnnotationNames(annotationsAttribute);
    }

    @Override
    public List<String> getFieldAnnotationNames(FieldInfo field) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)field.getAttribute("RuntimeVisibleAnnotations");
        return this.getAnnotationNames(annotationsAttribute);
    }

    @Override
    public List<String> getMethodAnnotationNames(MethodInfo method) {
        AnnotationsAttribute annotationsAttribute = (AnnotationsAttribute)method.getAttribute("RuntimeVisibleAnnotations");
        return this.getAnnotationNames(annotationsAttribute);
    }

    @Override
    public List<String> getParameterAnnotationNames(MethodInfo method, int parameterIndex) {
        Annotation[][] annotations;
        ParameterAnnotationsAttribute parameterAnnotationsAttribute = (ParameterAnnotationsAttribute)method.getAttribute("RuntimeVisibleParameterAnnotations");
        if (parameterAnnotationsAttribute != null && parameterIndex < (annotations = parameterAnnotationsAttribute.getAnnotations()).length) {
            Annotation[] annotation = annotations[parameterIndex];
            return this.getAnnotationNames(annotation);
        }
        return new ArrayList<String>();
    }

    @Override
    public String getReturnTypeName(MethodInfo method) {
        String descriptor = method.getDescriptor();
        descriptor = descriptor.substring(descriptor.lastIndexOf(")") + 1);
        return this.splitDescriptorToTypeNames(descriptor).get(0);
    }

    @Override
    public String getFieldName(FieldInfo field) {
        return field.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassFile createClassObject(InputStream inputStream) throws IOException {
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(inputStream));
            ClassFile classFile = new ClassFile((DataInputStream)dis);
            return classFile;
        }
        finally {
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException e) {
                    throw new ReflectionsException("could not close DataInputStream", e);
                }
            }
        }
    }

    @Override
    public String getMethodModifier(MethodInfo method) {
        int accessFlags = method.getAccessFlags();
        return AccessFlag.isPrivate((int)accessFlags) ? "private" : (AccessFlag.isProtected((int)accessFlags) ? "protected" : (AccessFlag.isPublic((int)accessFlags) ? "public" : ""));
    }

    @Override
    public String getMethodKey(ClassFile cls, MethodInfo method) {
        return this.getMethodName(method) + "(" + Joiner.on((String)", ").join(this.getParameterNames(method)) + ")";
    }

    @Override
    public String getMethodFullKey(ClassFile cls, MethodInfo method) {
        return this.getClassName(cls) + "." + this.getMethodKey(cls, method);
    }

    @Override
    public String getClassName(ClassFile cls) {
        return cls.getName();
    }

    @Override
    public String getSuperclassName(ClassFile cls) {
        return cls.getSuperclass();
    }

    @Override
    public List<String> getInterfacesNames(ClassFile cls) {
        return Arrays.asList(cls.getInterfaces());
    }

    private List<String> getAnnotationNames(AnnotationsAttribute annotationsAttribute) {
        if (annotationsAttribute == null) {
            return new ArrayList<String>(0);
        }
        Annotation[] annotations = annotationsAttribute.getAnnotations();
        return this.getAnnotationNames(annotations);
    }

    private List<String> getAnnotationNames(Annotation[] annotations) {
        ArrayList result = Lists.newArrayList();
        for (Annotation annotation : annotations) {
            result.add(annotation.getTypeName());
        }
        return result;
    }

    private List<String> splitDescriptorToTypeNames(String descriptors) {
        ArrayList result = Lists.newArrayList();
        if (descriptors != null && descriptors.length() != 0) {
            ArrayList indices = Lists.newArrayList();
            Descriptor.Iterator iterator = new Descriptor.Iterator(descriptors);
            while (iterator.hasNext()) {
                indices.add(iterator.next());
            }
            indices.add(descriptors.length());
            for (int i = 0; i < indices.size() - 1; ++i) {
                String s1 = Descriptor.toString((String)descriptors.substring((Integer)indices.get(i), (Integer)indices.get(i + 1)));
                result.add(s1);
            }
        }
        return result;
    }
}

