/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.ij;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.AdapterIInputStreamToInputStream;
import ch.systemsx.cisd.base.io.IInputStream;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.imagereaders.AbstractImageReader;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.IImageReaderLibrary;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import ij.ImagePlus;
import ij.io.Opener;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ImageJReaderLibrary
implements IImageReaderLibrary {
    private static final String TIFF_READER = "tiff";
    private static final List<String> TIFF_FILE_EXTS = Arrays.asList("tiff", "tif");
    private final IImageReader TIFF_IMAGE_READER = new AbstractImageReader(this.getName(), "tiff"){

        public BufferedImage readImage(IRandomAccessFile handle, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
            AdapterIInputStreamToInputStream is = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImagePlus imagePlus = new Opener().openTiff((InputStream)is, "");
            if (imagePlus == null) {
                throw new IllegalStateException("Cannot open the image file with ImageJ.");
            }
            return ImageJReaderLibrary.this.createBufferedImageOfSameType(imagePlus);
        }

        public Dimension readDimensions(IRandomAccessFile handle, ImageID imageID) {
            AdapterIInputStreamToInputStream is = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImagePlus imagePlus = new Opener().openTiff((InputStream)is, "");
            if (imagePlus == null) {
                throw new IllegalStateException("Cannot open the image file with ImageJ.");
            }
            return new Dimension(imagePlus.getWidth(), imagePlus.getHeight());
        }

        public Integer readColorDepth(IRandomAccessFile handle, ImageID imageID) {
            AdapterIInputStreamToInputStream is = new AdapterIInputStreamToInputStream((IInputStream)handle);
            ImagePlus imagePlus = new Opener().openTiff((InputStream)is, "");
            if (imagePlus == null) {
                throw new IllegalStateException("Cannot open the image file with ImageJ.");
            }
            return imagePlus.getBytesPerPixel();
        }
    };

    private BufferedImage createBufferedImageOfSameType(ImagePlus imagePlus) {
        ImageProcessor processor = imagePlus.getProcessor();
        if (processor instanceof ShortProcessor) {
            BufferedImage bufferedImage = ((ShortProcessor)processor).get16BitBufferedImage();
            return bufferedImage;
        }
        int bufferedImageType = ImageJReaderLibrary.findBufferedImageType(imagePlus);
        BufferedImage bufferedImage = new BufferedImage(imagePlus.getWidth(), imagePlus.getHeight(), bufferedImageType);
        Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
        g.drawImage(imagePlus.getImage(), 0, 0, null);
        return bufferedImage;
    }

    private static int findBufferedImageType(ImagePlus imagePlus) {
        switch (imagePlus.getType()) {
            case 0: {
                return 10;
            }
            case 1: 
            case 2: {
                return 11;
            }
            case 3: 
            case 4: {
                return 1;
            }
        }
        return 1;
    }

    public String getName() {
        return "IJ";
    }

    public List<String> getReaderNames() {
        return Collections.singletonList(TIFF_READER);
    }

    public IImageReader tryGetReader(String readerName) {
        return this.tryGetReaderForExtension(readerName);
    }

    public IImageReader tryGetReaderForFile(String fileName) {
        String fileExt = FilenameUtils.getExtension((String)fileName);
        return this.tryGetReaderForExtension(fileExt);
    }

    private IImageReader tryGetReaderForExtension(String fileExtension) {
        String lowerCaseExt;
        if (fileExtension != null && TIFF_FILE_EXTS.contains(lowerCaseExt = fileExtension.toLowerCase())) {
            return this.TIFF_IMAGE_READER;
        }
        return null;
    }
}

