/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.ij;

import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.IImageReader;
import ch.systemsx.cisd.imagereaders.ImageID;
import ch.systemsx.cisd.imagereaders.ImageReaderTestCase;
import ch.systemsx.cisd.imagereaders.ij.ImageJReaderLibrary;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class ImageJReaderLibraryTest
extends ImageReaderTestCase {
    @Test
    public void testMultiPageTIFF() throws FileNotFoundException {
        ImageJReaderLibrary library = new ImageJReaderLibrary();
        String libraryName = library.getName();
        File imageFile = this.getImageFileForLibrary(libraryName, "multi-page.tif");
        IImageReader reader = library.tryGetReaderForFile(imageFile.getPath());
        List imageIDs = reader.getImageIDs(imageFile);
        ImageJReaderLibraryTest.assertEquals((String)"[0-0-0-0]", (String)imageIDs.toString());
        Map metaData = reader.readMetaData(imageFile, (ImageID)imageIDs.get(0), null);
        ImageJReaderLibraryTest.assertEquals((int)0, (int)metaData.size());
        BufferedImage image0 = reader.readImage(imageFile, (ImageID)imageIDs.get(0), null);
        ImageJReaderLibraryTest.assertEquals((int)459, (int)image0.getWidth());
        ImageJReaderLibraryTest.assertEquals((int)435, (int)image0.getHeight());
        int depth = reader.readColorDepth((IRandomAccessFile)new RandomAccessFileImpl(new RandomAccessFile(imageFile, "r")), (ImageID)imageIDs.get(0));
        ImageJReaderLibraryTest.assertEquals((int)4, (int)depth);
    }
}

