/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.mdarray;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;

public class MDArray<T>
extends MDAbstractArray<T> {
    private static final long serialVersionUID = 1L;
    private T[] flattenedArray;

    public MDArray(Class<T> componentClass, long[] dimensions) {
        this(MDArray.createArray(componentClass, MDArray.getLength(dimensions, 0L)), MDArray.toInt(dimensions), false);
    }

    public MDArray(Class<T> componentClass, long[] dimensions, long capacityHyperRows) {
        this(MDArray.createArray(componentClass, MDArray.getLength(dimensions, capacityHyperRows)), MDArray.toInt(dimensions), false);
    }

    public MDArray(T[] flattenedArray, long[] dimensions) {
        this(flattenedArray, MDArray.toInt(dimensions), true);
    }

    public MDArray(T[] flattenedArray, long[] dimensions, boolean checkdimensions) {
        this(flattenedArray, MDArray.toInt(dimensions), checkdimensions);
    }

    public MDArray(Class<T> componentClass, int[] dimensions) {
        this(MDArray.createArray(componentClass, MDArray.getLength(dimensions, 0)), dimensions, false);
    }

    public MDArray(Class<T> componentClass, int[] dimensions, int capacityHyperRows) {
        this(MDArray.createArray(componentClass, MDArray.getLength(dimensions, capacityHyperRows)), dimensions, false);
    }

    public MDArray(T[] flattenedArray, int[] dimensions) {
        this(flattenedArray, dimensions, true);
    }

    public MDArray(T[] flattenedArray, int[] dimensions, boolean checkdimensions) {
        super(dimensions, flattenedArray.length, 0);
        int expectedLength;
        assert (flattenedArray != null);
        if (checkdimensions && flattenedArray.length != (expectedLength = MDArray.getLength(dimensions, 0))) {
            throw new IllegalArgumentException("Actual array length " + flattenedArray.length + " does not match expected length " + expectedLength + ".");
        }
        this.flattenedArray = flattenedArray;
    }

    private static <V> V[] createArray(Class<V> componentClass, int vectorLength) {
        Object[] value = (Object[])Array.newInstance(componentClass, vectorLength);
        return value;
    }

    @Override
    public int capacity() {
        return this.flattenedArray.length;
    }

    @Override
    public T getAsObject(int ... indices) {
        return this.get(indices);
    }

    @Override
    public void setToObject(T value, int ... indices) {
        this.set(value, indices);
    }

    @Override
    public T getAsObject(int linearIndex) {
        return this.get(linearIndex);
    }

    @Override
    public void setToObject(T value, int linearIndex) {
        this.set(value, linearIndex);
    }

    public T[] getAsFlatArray() {
        return this.flattenedArray;
    }

    public T[] getCopyAsFlatArray() {
        return this.toTArray(ArrayUtils.subarray((Object[])this.flattenedArray, (int)0, (int)(this.dimensions[0] * this.hyperRowLength)));
    }

    @Override
    protected void adaptCapacityHyperRows() {
        T[] oldArray = this.flattenedArray;
        this.flattenedArray = this.toTArray(MDArray.createArray(oldArray.getClass().getComponentType(), this.capacityHyperRows * this.hyperRowLength));
        System.arraycopy(oldArray, 0, this.flattenedArray, 0, Math.min(oldArray.length, this.flattenedArray.length));
    }

    private T[] toTArray(Object obj) {
        return (Object[])obj;
    }

    public T get(int ... indices) {
        return this.flattenedArray[this.computeIndex(indices)];
    }

    public T get(int index) {
        return this.flattenedArray[index];
    }

    public T get(int indexX, int indexY) {
        return this.flattenedArray[this.computeIndex(indexX, indexY)];
    }

    public T get(int indexX, int indexY, int indexZ) {
        return this.flattenedArray[this.computeIndex(indexX, indexY, indexZ)];
    }

    public void set(T value, int ... indices) {
        this.flattenedArray[this.computeIndex((int[])indices)] = value;
    }

    public void set(T value, int index) {
        this.flattenedArray[index] = value;
    }

    public void set(T value, int indexX, int indexY) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY)] = value;
    }

    public void set(T value, int indexX, int indexY, int indexZ) {
        this.flattenedArray[this.computeIndex((int)indexX, (int)indexY, (int)indexZ)] = value;
    }

    public Class<T> getComponentClass() {
        return this.flattenedArray.getClass().getComponentType();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.getValuesAsFlatArray());
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MDArray<T> other = this.toMDArray(obj);
        if (!Arrays.equals(this.getValuesAsFlatArray(), super.getValuesAsFlatArray())) {
            return false;
        }
        return Arrays.equals(this.dimensions, other.dimensions);
    }

    private T[] getValuesAsFlatArray() {
        return this.dimensions[0] < this.capacityHyperRows ? this.getCopyAsFlatArray() : this.getAsFlatArray();
    }

    private MDArray<T> toMDArray(Object obj) {
        return (MDArray)obj;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.hyperRowLength == 0) {
            this.hyperRowLength = this.computeHyperRowLength(this.dimensions);
        }
        if (this.capacityHyperRows == 0) {
            this.capacityHyperRows = this.dimensions[0];
        }
        if (this.size == 0) {
            this.size = this.hyperRowLength * this.dimensions[0];
        }
    }
}

