/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.compile;

import ch.ethz.cisd.compile.JavaSourceFromString;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SimpleJavaCompiler
implements Closeable {
    private static final Log log = LogFactory.getLog(SimpleJavaCompiler.class);
    private static final Pattern classNamePattern = Pattern.compile("^\\s*public\\s+class\\s+(\\w+)", 8);
    private static final int BUFFER_SIZE = 10240;
    private final File tempDir;
    private final JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private final List<String> compilerOptions;
    private final StandardJavaFileManager fileManager = this.compiler.getStandardFileManager(null, null, null);
    private final DiagnosticCollector<JavaFileObject> diagnostics;
    private final StringWriter logWriter;
    private String lastClassName;
    private boolean done;

    private static File createTempDirectory(File rootDirectoryOrNull, String prefix) throws IOExceptionUnchecked {
        File temp;
        try {
            temp = File.createTempFile(prefix, Long.toString(System.nanoTime()), rootDirectoryOrNull);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        if (!temp.delete()) {
            throw new IOExceptionUnchecked("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOExceptionUnchecked("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean createJarArchive(File archiveFile, File root, Iterable<File> tobeJared) {
        byte[] buffer = new byte[10240];
        FileOutputStream stream = null;
        JarOutputStream out = null;
        long oldLastChanged = archiveFile.lastModified();
        File archiveFileInProcess = new File(archiveFile.getParentFile(), archiveFile.getName() + ".incomplete");
        try {
            stream = new FileOutputStream(archiveFileInProcess);
            out = new JarOutputStream((OutputStream)stream, new Manifest());
            for (File file : tobeJared) {
                int nRead;
                if (file == null || !file.exists() || file.isDirectory()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding " + file.getName() + " to archive " + archiveFile));
                }
                JarEntry jarAdd = new JarEntry(SimpleJavaCompiler.getRelativePath(root, file));
                jarAdd.setTime(file.lastModified());
                out.putNextEntry(jarAdd);
                FileInputStream in = new FileInputStream(file);
                while ((nRead = in.read(buffer, 0, buffer.length)) > 0) {
                    out.write(buffer, 0, nRead);
                }
                in.close();
            }
            out.close();
            stream.close();
            boolean i$ = true;
            return i$;
        }
        catch (Exception ex) {
            IOUtils.closeQuietly((OutputStream)stream);
            IOUtils.closeQuietly(out);
            archiveFile.delete();
            log.error((Object)("Error when creating the jar archive " + archiveFile), (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            if (oldLastChanged == archiveFileInProcess.lastModified()) {
                archiveFileInProcess.setLastModified(oldLastChanged + 1000L);
            }
            archiveFile.delete();
            if (archiveFile.exists()) {
                throw new IOExceptionUnchecked("Cannot delete old archive file " + archiveFile.getAbsolutePath());
            }
            archiveFileInProcess.renameTo(archiveFile);
        }
    }

    private static String getRelativePath(File root, File file) {
        String absoluteRoot = root.getAbsolutePath();
        String absolutePath = file.getAbsolutePath();
        return absolutePath.startsWith(absoluteRoot) ? absolutePath.substring(absoluteRoot.length() + 1) : absolutePath;
    }

    static String tryFindClassname(String classNameOrNull, String classSource) {
        if (classNameOrNull != null) {
            return classNameOrNull;
        }
        Matcher matcher = classNamePattern.matcher(classSource);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public SimpleJavaCompiler() throws IOExceptionUnchecked {
        this(null);
    }

    public SimpleJavaCompiler(File tempRootDirectoryOrNull) throws IOExceptionUnchecked {
        this.tempDir = SimpleJavaCompiler.createTempDirectory(tempRootDirectoryOrNull, "javaCompile");
        this.diagnostics = new DiagnosticCollector();
        this.logWriter = new StringWriter();
        this.compilerOptions = new ArrayList<String>();
        this.compilerOptions.addAll(Arrays.asList("-classpath", System.getProperty("java.class.path")));
        this.compilerOptions.addAll(Arrays.asList("-d", this.tempDir.getAbsolutePath()));
    }

    public String getLastClassName() {
        return this.lastClassName;
    }

    public List<String> getCompilerOptions() {
        return this.compilerOptions;
    }

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.diagnostics.getDiagnostics();
    }

    public String getErrorMessage() {
        StringBuilder builder = new StringBuilder();
        for (Diagnostic<? extends JavaFileObject> d : this.getDiagnostics()) {
            builder.append(d.toString());
            builder.append('\n');
        }
        builder.append(this.logWriter.toString());
        return builder.toString();
    }

    private void checkDone() {
        if (this.done) {
            throw new IllegalStateException("Cannot use SImpleJavaCompiler object after cleanUp() has been called.");
        }
    }

    public JavaFileObject tryGetFileObjectFromSourceCode(String classSource) {
        return this.tryGetFileObjectFromSourceCode(null, classSource);
    }

    public JavaFileObject tryGetFileObjectFromSourceCode(String classNameOrNull, String classSource) {
        this.checkDone();
        String className = SimpleJavaCompiler.tryFindClassname(classNameOrNull, classSource);
        if (className == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Couldn't determine classname for source code:\n" + classSource));
            }
            return null;
        }
        return new JavaSourceFromString(className, classSource);
    }

    public JavaFileObject tryGetFileObjectForFile(File javaFile) {
        this.checkDone();
        Iterator<? extends JavaFileObject> javaFileObjects = this.fileManager.getJavaFileObjects(javaFile).iterator();
        return javaFileObjects.hasNext() ? javaFileObjects.next() : null;
    }

    public Iterable<? extends JavaFileObject> getFileObjectsForDirectory(File directory) {
        this.checkDone();
        Collection javaFiles = FileUtils.listFiles((File)directory, (String[])new String[]{"java"}, (boolean)true);
        return this.fileManager.getJavaFileObjectsFromFiles(javaFiles);
    }

    public boolean compile(Iterable<? extends JavaFileObject> fileObjects) throws IOExceptionUnchecked {
        JavaFileObject lastFile;
        boolean ok;
        this.checkDone();
        Boolean okObj = this.compiler.getTask(this.logWriter, this.fileManager, this.diagnostics, this.compilerOptions, null, fileObjects).call();
        boolean bl = ok = okObj != null && okObj != false;
        if (ok && (lastFile = this.getLast(fileObjects)) != null) {
            this.lastClassName = lastFile.getName();
            if (this.lastClassName.endsWith(".java")) {
                this.lastClassName = this.lastClassName.substring(0, this.lastClassName.length() - ".java".length());
            }
        }
        return ok;
    }

    /*
     * WARNING - void declaration
     */
    private JavaFileObject getLast(Iterable<? extends JavaFileObject> fileObjects) {
        void var2_4;
        if (fileObjects instanceof List) {
            List list = (List)fileObjects;
            return (JavaFileObject)list.get(list.size() - 1);
        }
        Object var2_3 = null;
        for (JavaFileObject javaFileObject : fileObjects) {
        }
        return var2_4;
    }

    public boolean compile(JavaFileObject ... fileObjects) throws IOExceptionUnchecked {
        return this.compile(Arrays.asList(fileObjects));
    }

    public void addFile(File source, String destPath) throws IOExceptionUnchecked {
        File destFile = new File(this.tempDir, destPath);
        destFile.getParentFile().mkdirs();
        try {
            FileUtils.copyFile((File)source, (File)destFile);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    public void addContent(InputStream istream, String destPath) throws IOExceptionUnchecked {
        File destFile = new File(this.tempDir, destPath);
        destFile.getParentFile().mkdirs();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(destFile);
            IOUtils.copyLarge((InputStream)istream, (OutputStream)ostream);
        }
        catch (IOException ex) {
            try {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ostream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)ostream);
    }

    public File tryCreateJar() {
        return this.tryCreateJar(null, null);
    }

    public File tryCreateJar(File outputDirectoryOrNull) {
        return this.tryCreateJar(outputDirectoryOrNull, null);
    }

    public File tryCreateJar(String jarFilenameOrNull) {
        return this.tryCreateJar(null, jarFilenameOrNull);
    }

    public File tryCreateJar(File outputDirectoryOrNull, String jarFilenameOrNull) {
        Collection classFiles;
        String jarFilename;
        this.checkDone();
        String string = jarFilename = jarFilenameOrNull != null ? jarFilenameOrNull : this.lastClassName;
        if (jarFilename == null) {
            if (!this.logWriter.toString().isEmpty()) {
                this.logWriter.append('\n');
            }
            this.logWriter.append("Cannot find name for jar file (neither explicity given nor inferreable).");
            return null;
        }
        File outputJarfile = outputDirectoryOrNull != null ? new File(outputDirectoryOrNull, jarFilename + ".jar") : new File(jarFilename + ".jar");
        if (SimpleJavaCompiler.createJarArchive(outputJarfile, this.tempDir, classFiles = FileUtils.listFiles((File)this.tempDir, (IOFileFilter)FileFileFilter.FILE, (IOFileFilter)TrueFileFilter.TRUE))) {
            return outputJarfile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File tryCompileAndJarFromString(String classSource, File outputDir) throws IOExceptionUnchecked {
        this.checkDone();
        try {
            JavaFileObject fileObject = this.tryGetFileObjectFromSourceCode(classSource);
            if (fileObject == null) {
                File file = null;
                return file;
            }
            if (!this.compile(fileObject)) {
                File file = null;
                return file;
            }
            File file = this.tryCreateJar(outputDir);
            return file;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File tryCompileAndJarFromFiles(File sourceDirectory, File outputDir, String jarFilename) throws IOExceptionUnchecked {
        try {
            Iterable<? extends JavaFileObject> fileObjects = this.getFileObjectsForDirectory(sourceDirectory);
            if (!this.compile(fileObjects)) {
                File file = null;
                return file;
            }
            File file = this.tryCreateJar(outputDir);
            return file;
        }
        finally {
            this.close();
        }
    }

    public File getTempDir() {
        return this.tempDir;
    }

    public StringWriter getLogWriter() {
        return this.logWriter;
    }

    @Override
    public void close() throws IOExceptionUnchecked {
        try {
            FileUtils.deleteDirectory((File)this.tempDir);
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
        this.done = true;
    }
}

