/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.BuildAndEnvironmentInfo;
import ch.ethz.cisd.hotdeploy.PluginContainerParameters;
import ch.ethz.cisd.hotdeploy.PluginDescriptor;
import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginEventListener;
import ch.ethz.cisd.hotdeploy.PluginEventNotifier;
import ch.ethz.cisd.hotdeploy.PluginInfo;
import ch.ethz.cisd.hotdeploy.PluginLoader;
import ch.ethz.cisd.hotdeploy.ReflectionUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PluginContainer {
    private static final Log log = LogFactory.getLog(PluginContainer.class);
    private static final long MAX_TIME_IN_SECS_TO_WAIT_FOR_LOAD_CYCLE = 5L;
    private static final String MAIN_PLUGIN_CONTAINER_NAME = "MAIN";
    private static final Map<String, PluginContainer> instances = Collections.synchronizedMap(new HashMap());
    private final String containerName;
    private final boolean runGcOnShutdown;
    private Thread loaderThread;
    private PluginLoader loader;
    private PluginEventNotifier notifier;
    private Map<String, PluginDescriptor> classNameMap = new HashMap<String, PluginDescriptor>();
    private Map<String, PluginDescriptor> pluginNameMap = new HashMap<String, PluginDescriptor>();
    private Map<File, PluginDescriptor> pluginJarMap = new HashMap<File, PluginDescriptor>();
    private Map<File, Set<PluginDescriptor>> pluginDirToPluginSetMap = new HashMap<File, Set<PluginDescriptor>>();

    private PluginContainer(String name, PluginContainerParameters params) {
        this.containerName = name;
        long begin = System.nanoTime();
        this.runGcOnShutdown = params.isRunGCOnShutdown();
        if (this.runGcOnShutdown) {
            log.info((Object)"Running GC on shutdown.");
        } else {
            log.info((Object)"Not running GC on shutdown.");
        }
        this.notifier = new PluginEventNotifier();
        this.loader = new PluginLoader(this, params);
        this.loaderThread = new Thread((Runnable)this.loader, "ch.ethz.cisd.hotdeploy.PluginLoader (" + name + ")");
        this.loaderThread.setDaemon(true);
        CountDownLatch firstRoundSync = this.loader.getCycleFinishedBarrier();
        this.loaderThread.start();
        try {
            firstRoundSync.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        String ms = String.valueOf((double)(System.nanoTime() - begin) / 1000000.0);
        log.info((Object)("PluginContainer initialized (" + ms + "ms)."));
        log.info((Object)(BuildAndEnvironmentInfo.INSTANCE.getApplicationName() + " v" + BuildAndEnvironmentInfo.INSTANCE.getFullVersion() + " is ready."));
    }

    public String getContainerName() {
        return this.containerName;
    }

    public void addListener(PluginEventListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(PluginEventListener listener) {
        this.notifier.removeListener(listener);
    }

    public Set<File> getPluginDirectories() {
        return this.loader.getPluginDirectories();
    }

    public void addPluginDirectory(File pluginDirectory) {
        this.addPluginDirectory(pluginDirectory, true);
    }

    public void addPluginDirectory(File pluginDirectory, boolean synchronous) {
        if (!pluginDirectory.isDirectory()) {
            log.warn((Object)("path " + pluginDirectory + " is not a directory"));
        }
        this.loader.addPluginDirectory(pluginDirectory);
        log.info((Object)("add plugin directory " + pluginDirectory));
        this.refresh(synchronous);
    }

    public void addPluginDirectories(Collection<File> pluginDirectoriesToBeAdded) {
        this.addPluginDirectories(pluginDirectoriesToBeAdded, true);
    }

    public void addPluginDirectories(Collection<File> pluginDirectoriesToBeAdded, boolean synchronous) {
        for (File pluginDirectory : pluginDirectoriesToBeAdded) {
            if (pluginDirectory.isDirectory()) continue;
            log.warn((Object)("path " + pluginDirectory + " is not a directory"));
        }
        this.loader.addPluginDirectories(pluginDirectoriesToBeAdded);
        log.info((Object)("add plugin directories " + pluginDirectoriesToBeAdded));
        this.refresh(synchronous);
    }

    public void removePluginDirectory(File pluginDirectory) {
        this.removePluginDirectory(pluginDirectory, true);
    }

    public void removePluginDirectory(File pluginDirectory, boolean synchronous) {
        this.loader.removePluginDirectory(pluginDirectory);
        log.info((Object)("remove plugin directory " + pluginDirectory));
        this.refresh(synchronous);
    }

    public void removePluginDirectories(Collection<File> pluginDirectoriesToBeRemoved) {
        this.removePluginDirectories(pluginDirectoriesToBeRemoved, true);
    }

    public void removePluginDirectories(Collection<File> pluginDirectoriesToBeRemoved, boolean synchronous) {
        this.loader.removePluginDirectories(pluginDirectoriesToBeRemoved);
        log.info((Object)("remove plugin directories " + pluginDirectoriesToBeRemoved));
        this.refresh(synchronous);
    }

    public void setPluginDirectories(Collection<File> newPluginDirectories) {
        this.setPluginDirectories(newPluginDirectories, true);
    }

    public void setPluginDirectories(Collection<File> newPluginDirectories, boolean synchronous) {
        for (File pluginDirectory : newPluginDirectories) {
            if (pluginDirectory.isDirectory()) continue;
            log.warn((Object)("path " + pluginDirectory + " is not a directory"));
        }
        this.loader.setPluginDirectories(newPluginDirectories);
        log.info((Object)("set plugin directories to " + newPluginDirectories));
        this.refresh(synchronous);
    }

    synchronized void register(PluginDescriptor desc, boolean newPlugin) {
        if (desc == null) {
            String msg = "register plugin called with null argument.";
            log.error((Object)msg, (Throwable)new Exception(msg));
            return;
        }
        String classname = desc.getPluginClassname();
        this.classNameMap.put(classname, desc);
        this.pluginNameMap.put(desc.getPluginName(), desc);
        this.pluginJarMap.put(desc.getPluginArchive(), desc);
        this.addArchiveToPluginDirMap(desc);
        PluginEvent.PluginEventType eventType = newPlugin ? PluginEvent.PluginEventType.REGISTER_NEW_PLUGIN : PluginEvent.PluginEventType.UPDATE_PLUGIN;
        this.notifier.notifyListeners(new PluginEvent(eventType, desc.getPluginClass(), desc.getPluginArchive()));
    }

    private void addArchiveToPluginDirMap(PluginDescriptor pluginDesc) {
        File pluginDir = pluginDesc.getPluginDirectory();
        Set<PluginDescriptor> pluginsInDir = this.pluginDirToPluginSetMap.get(pluginDir);
        if (pluginsInDir == null) {
            pluginsInDir = new HashSet<PluginDescriptor>();
            this.pluginDirToPluginSetMap.put(pluginDir, pluginsInDir);
        }
        pluginsInDir.add(pluginDesc);
    }

    synchronized void unregister(PluginDescriptor desc) {
        boolean isUnregistered;
        if (desc == null) {
            String msg = "unregister plugin called with null argument.";
            log.error((Object)msg, (Throwable)new Exception(msg));
            return;
        }
        boolean bl = isUnregistered = this.classNameMap.remove(desc.getPluginClassname()) != null;
        if (isUnregistered) {
            this.pluginNameMap.remove(desc.getPluginName());
            this.removePluginFromPluginDirMap(desc);
            this.pluginJarMap.remove(desc.getPluginArchive());
            this.notifier.notifyListeners(new PluginEvent(PluginEvent.PluginEventType.UNREGISTER_PLUGIN, desc.getPluginClass(), desc.getPluginArchive()));
        }
    }

    private void removePluginFromPluginDirMap(PluginDescriptor pluginDesc) {
        Set<PluginDescriptor> pluginsInDir = this.pluginDirToPluginSetMap.get(pluginDesc.getPluginDirectory());
        if (pluginsInDir != null) {
            pluginsInDir.remove(pluginDesc);
        }
    }

    public static PluginContainer initHotDeployment(PluginContainerParameters params) {
        return PluginContainer.initHotDeployment(MAIN_PLUGIN_CONTAINER_NAME, params);
    }

    public static PluginContainer initHotDeployment(String containerName, PluginContainerParameters params) {
        PluginContainer instance = instances.get(containerName);
        if (instance == null) {
            instance = new PluginContainer(containerName, params);
            instances.put(containerName, instance);
        }
        return instance;
    }

    public static PluginContainer initHotDeployment(String containerName, long scanIntervalMillis) {
        return PluginContainer.initHotDeployment(containerName, new PluginContainerParameters().scanIntervalMillis(scanIntervalMillis));
    }

    public static PluginContainer initHotDeployment(long scanIntervalMillis) {
        return PluginContainer.initHotDeployment(MAIN_PLUGIN_CONTAINER_NAME, scanIntervalMillis);
    }

    public static PluginContainer initHotDeployment(String containerName) {
        return PluginContainer.initHotDeployment(containerName, new PluginContainerParameters());
    }

    public static PluginContainer initHotDeployment() {
        return PluginContainer.initHotDeployment(MAIN_PLUGIN_CONTAINER_NAME);
    }

    public static PluginContainer tryGetInstance() {
        return instances.get(MAIN_PLUGIN_CONTAINER_NAME);
    }

    public static PluginContainer tryGetInstance(String containerName) {
        return instances.get(containerName);
    }

    public void refresh(boolean synchronous) {
        if (synchronous) {
            CountDownLatch sync = this.loader.getCycleFinishedBarrier();
            this.loaderThread.interrupt();
            try {
                sync.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.loaderThread.interrupt();
        }
    }

    public Class<?> tryGetPluginClassByClassname(String classname) {
        return this.tryGetPluginClassByClassname(classname, Object.class);
    }

    public Class<?> tryGetPluginClass(String name) {
        return this.tryGetPluginClass(name, false, Object.class);
    }

    public <T> Class<T> tryGetPluginClass(File jarfile, Class<T> clazz) {
        if (jarfile == null) {
            return null;
        }
        PluginDescriptor desc = this.tryGetPluginDesc(jarfile, true);
        if (desc == null) {
            return null;
        }
        this.checkImplements(desc, clazz);
        return desc.getPluginClass();
    }

    public Class<?> tryGetPluginClass(File jarfile) {
        return this.tryGetPluginClass(jarfile, Object.class);
    }

    public PluginInfo tryGetPluginInfoByClassname(String classname) {
        PluginDescriptor desc = this.tryGetPluginDesc(classname, true, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginInfo();
    }

    public PluginInfo tryGetPluginInfo(String name) {
        PluginDescriptor desc = this.tryGetPluginDesc(name, false, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginInfo();
    }

    public PluginInfo tryGetPluginInfo(File jarfile) {
        PluginDescriptor desc = this.tryGetPluginDesc(jarfile, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginInfo();
    }

    public String tryGetPluginNameByClassname(String classname) {
        PluginDescriptor desc = this.tryGetPluginDesc(classname, true, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginName();
    }

    public String tryGetPluginName(File jarfile) {
        PluginDescriptor desc = this.tryGetPluginDesc(jarfile, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginName();
    }

    public String tryGetPluginClassname(String name) {
        PluginDescriptor desc = this.tryGetPluginDesc(name, false, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginClassname();
    }

    public String tryGetPluginClassname(File jarfile) {
        PluginDescriptor desc = this.tryGetPluginDesc(jarfile, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginClassname();
    }

    public Class<?> tryGetPluginTypeByClassname(String classname) {
        PluginDescriptor desc = this.tryGetPluginDesc(classname, true, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginType();
    }

    public Class<?> tryGetPluginType(String name) {
        PluginDescriptor desc = this.tryGetPluginDesc(name, false, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginType();
    }

    public boolean hasPluginByClassname(String classname) {
        return this.tryGetPluginClassByClassname(classname) != null;
    }

    public boolean hasPlugin(String name) {
        return this.tryGetPluginClass(name) != null;
    }

    public boolean hasConstructorByClassname(String classname, Class<?> ... constructorArgumentTypes) {
        Class<?> pluginClass = this.tryGetPluginClassByClassname(classname);
        if (pluginClass == null) {
            return false;
        }
        return ReflectionUtils.tryGetConstructor(pluginClass, constructorArgumentTypes) != null;
    }

    public boolean hasConstructor(String name, Class<?> ... constructorArgumentTypes) {
        Class<?> pluginClass = this.tryGetPluginClass(name);
        if (pluginClass == null) {
            return false;
        }
        return ReflectionUtils.tryGetConstructor(pluginClass, constructorArgumentTypes) != null;
    }

    public boolean hasConstructor(File jarfile, Class<?> ... constructorArgumentTypes) {
        Class<?> pluginClass = this.tryGetPluginClass(jarfile);
        if (pluginClass == null) {
            return false;
        }
        return ReflectionUtils.tryGetConstructor(pluginClass, constructorArgumentTypes) != null;
    }

    public File tryGetPluginArchiveByClassname(String classname) {
        if (classname == null) {
            return null;
        }
        PluginDescriptor desc = this.tryGetPluginDesc(classname, true, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginArchive();
    }

    public File tryGetPluginArchive(String name) {
        if (name == null) {
            return null;
        }
        PluginDescriptor desc = this.tryGetPluginDesc(name, false, true);
        if (desc == null) {
            return null;
        }
        return desc.getPluginArchive();
    }

    public byte[] tryGetPluginResource(File pluginArchive, final String resource) {
        if (pluginArchive == null) {
            return null;
        }
        return this.loader.tryRunLocked(pluginArchive, new PluginLoader.ClassLoaderCallable<byte[]>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] call(ClassLoader classLoader) throws Exception {
                InputStream istream = classLoader.getResourceAsStream(resource);
                try {
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)istream, (OutputStream)ostream);
                    byte[] byArray = ostream.toByteArray();
                    return byArray;
                }
                finally {
                    istream.close();
                }
            }
        });
    }

    public <T> Class<T> tryGetPluginClassByClassname(String classname, Class<T> clazz) {
        return this.tryGetPluginClass(classname, true, clazz);
    }

    public <T> Class<T> tryGetPluginClass(String name, Class<T> clazz) {
        return this.tryGetPluginClass(name, false, clazz);
    }

    <T> Class<T> tryGetPluginClass(String classname, boolean useClassname, Class<T> clazz) {
        if (classname == null) {
            return null;
        }
        PluginDescriptor desc = this.tryGetPluginDesc(classname, useClassname, true);
        if (desc == null) {
            return null;
        }
        this.checkImplements(desc, clazz);
        return desc.getPluginClass();
    }

    private <T> void checkImplements(PluginDescriptor desc, Class<T> clazz) {
        if (!desc.isImplementing(clazz)) {
            throw new ClassCastException("Class " + desc.getPluginClassname() + " is not a " + clazz.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginDescriptor tryGetPluginDesc(String name, boolean useClassname, boolean updateIfOutdated) {
        PluginDescriptor desc;
        PluginContainer pluginContainer = this;
        synchronized (pluginContainer) {
            desc = useClassname ? this.classNameMap.get(name) : this.pluginNameMap.get(name);
        }
        if (updateIfOutdated && this.updateIfNecessary(desc)) {
            pluginContainer = this;
            synchronized (pluginContainer) {
                desc = useClassname ? this.classNameMap.get(name) : this.pluginNameMap.get(name);
            }
        }
        return desc;
    }

    private boolean updateIfNecessary(PluginDescriptor desc) {
        if (desc != null && desc.hasPluginArchiveChanged()) {
            long start = System.currentTimeMillis();
            this.refresh(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("refresh took " + (System.currentTimeMillis() - start) + "ms"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PluginDescriptor tryGetPluginDesc(File jarfile, boolean updateIfOutdated) {
        PluginDescriptor desc;
        PluginContainer pluginContainer = this;
        synchronized (pluginContainer) {
            desc = this.pluginJarMap.get(jarfile);
        }
        if (updateIfOutdated && this.updateIfNecessary(desc)) {
            pluginContainer = this;
            synchronized (pluginContainer) {
                desc = this.pluginJarMap.get(jarfile);
            }
        }
        return desc;
    }

    public <T> T tryCreatePluginByClassname(String classname, Class<T> workerInterface, Object ... constructorArguments) {
        Class<T> pluginClass = this.tryGetPluginClassByClassname(classname, workerInterface);
        if (pluginClass == null) {
            return null;
        }
        return ReflectionUtils.create(workerInterface, pluginClass, constructorArguments);
    }

    public <T> T tryCreatePlugin(String name, Class<T> workerInterface, Object ... constructorArguments) {
        Class<T> pluginClass = this.tryGetPluginClass(name, workerInterface);
        if (pluginClass == null) {
            return null;
        }
        return ReflectionUtils.create(workerInterface, pluginClass, constructorArguments);
    }

    public <T> T tryCreatePlugin(File jarfile, Class<T> workerInterface, Object ... constructorArguments) {
        Class<T> pluginClass = this.tryGetPluginClass(jarfile, workerInterface);
        if (pluginClass == null) {
            return null;
        }
        return ReflectionUtils.create(workerInterface, pluginClass, constructorArguments);
    }

    public synchronized Set<String> getPluginClassnames() {
        HashSet<String> classnames = new HashSet<String>();
        classnames.addAll(this.classNameMap.keySet());
        return classnames;
    }

    public synchronized Set<String> getPluginNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.pluginNameMap.keySet());
        return names;
    }

    public synchronized Set<Class<?>> getPluginTypes() {
        HashSet types = new HashSet();
        for (PluginDescriptor desc : this.classNameMap.values()) {
            types.add(desc.getPluginType());
        }
        return types;
    }

    public synchronized Set<String> getPluginClassnames(Class<?> pluginType) {
        HashSet<String> classnames = new HashSet<String>();
        for (PluginDescriptor desc : this.classNameMap.values()) {
            if (pluginType != null && !desc.isImplementing(pluginType)) continue;
            classnames.add(desc.getPluginClassname());
        }
        return classnames;
    }

    public synchronized List<PluginDescriptor> getPlugins() {
        return new ArrayList<PluginDescriptor>(this.classNameMap.values());
    }

    public synchronized List<PluginDescriptor> getPlugins(Class<?> pluginType) {
        ArrayList<PluginDescriptor> list = new ArrayList<PluginDescriptor>(this.classNameMap.size());
        for (PluginDescriptor desc : this.classNameMap.values()) {
            if (pluginType != null && !desc.isImplementing(pluginType)) continue;
            list.add(desc);
        }
        return list;
    }

    public synchronized Set<String> getPluginNames(Class<?> pluginType) {
        HashSet<String> classnames = new HashSet<String>();
        for (PluginDescriptor desc : this.classNameMap.values()) {
            if (pluginType != null && !desc.isImplementing(pluginType)) continue;
            classnames.add(desc.getPluginName());
        }
        return classnames;
    }

    public synchronized Set<String> getPluginClassnamesForArchiveDir(File pluginDir) {
        HashSet<String> classnames = new HashSet<String>();
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginDir);
        if (pluginsInPluginDir != null) {
            for (PluginDescriptor desc : pluginsInPluginDir) {
                classnames.add(desc.getPluginClassname());
            }
        }
        return classnames;
    }

    public synchronized Set<String> getPluginNamesForArchiveDir(File pluginDir) {
        HashSet<String> classnames = new HashSet<String>();
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginDir);
        if (pluginsInPluginDir != null) {
            for (PluginDescriptor desc : pluginsInPluginDir) {
                classnames.add(desc.getPluginName());
            }
        }
        return classnames;
    }

    public synchronized String getPluginClassnameForArchive(File pluginArchive) {
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginArchive.getParentFile());
        if (pluginsInPluginDir == null) {
            return null;
        }
        for (PluginDescriptor desc : pluginsInPluginDir) {
            if (!pluginArchive.equals(desc.getPluginArchive())) continue;
            return desc.getPluginClassname();
        }
        return null;
    }

    public synchronized Set<String> getPluginClassnames(File pluginDir, Class<?> pluginType) {
        HashSet<String> classnames = new HashSet<String>();
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginDir);
        if (pluginsInPluginDir != null) {
            for (PluginDescriptor desc : pluginsInPluginDir) {
                if (pluginType != null && !desc.isImplementing(pluginType)) continue;
                classnames.add(desc.getPluginClassname());
            }
        }
        return classnames;
    }

    public synchronized Set<Class<?>> getPluginClasses() {
        HashSet plugins = new HashSet();
        for (PluginDescriptor desc : this.classNameMap.values()) {
            plugins.add(desc.getPluginClass());
        }
        return plugins;
    }

    public synchronized Set<Class<?>> getPluginClasses(Class<?> pluginType) {
        HashSet plugins = new HashSet();
        for (PluginDescriptor desc : this.classNameMap.values()) {
            if (!desc.isImplementing(pluginType)) continue;
            plugins.add(desc.getPluginClass());
        }
        return plugins;
    }

    public Set<Class<?>> getPluginClasses(File pluginDir) {
        return this.getPluginClasses(pluginDir, null);
    }

    public synchronized Set<Class<?>> getPluginClasses(File pluginDir, Class<?> pluginType) {
        HashSet plugins = new HashSet();
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginDir);
        if (pluginsInPluginDir != null) {
            for (PluginDescriptor desc : pluginsInPluginDir) {
                if (pluginType != null && !desc.isImplementing(pluginType)) continue;
                plugins.add(desc.getPluginClass());
            }
        }
        return plugins;
    }

    public synchronized boolean disablePlugin(Class<?> plugin) {
        if (plugin == null) {
            log.warn((Object)"disable plugin called with null - ignoring.");
            return false;
        }
        PluginDescriptor desc = this.classNameMap.get(plugin.getName());
        if (desc == null) {
            log.warn((Object)("disable plugin called with class " + plugin.getName() + " that is not a plugin - ignoring."));
            return false;
        }
        this.unregister(desc);
        return this.loader.disablePlugin(plugin);
    }

    public synchronized boolean disablePlugin(File pluginArchive) {
        if (pluginArchive == null) {
            log.warn((Object)"disable plugin called with null - ignoring.");
            return false;
        }
        Set<PluginDescriptor> pluginsInPluginDir = this.pluginDirToPluginSetMap.get(pluginArchive.getParentFile());
        if (pluginsInPluginDir != null) {
            for (PluginDescriptor desc : pluginsInPluginDir) {
                if (!desc.getPluginArchive().equals(pluginArchive)) continue;
                this.unregister(desc);
                break;
            }
        }
        return this.loader.disablePlugin(pluginArchive);
    }

    public boolean enablePlugin(File pluginArchive, boolean synchronous) {
        if (pluginArchive == null) {
            log.warn((Object)"enable plugin called with null - ignoring.");
            return false;
        }
        if (!this.enableArchiveFile(pluginArchive)) {
            return false;
        }
        this.refresh(synchronous);
        return true;
    }

    private boolean enableArchiveFile(File pluginArchive) {
        if (pluginArchive.isFile() && pluginArchive.getName().endsWith(".jar")) {
            return true;
        }
        File disabledPluginArchive = new File(pluginArchive.getAbsolutePath() + ".disabled");
        if (!disabledPluginArchive.isFile()) {
            return false;
        }
        return disabledPluginArchive.renameTo(pluginArchive);
    }

    public static void shutdown(String containerName) {
        PluginContainer instance = instances.get(containerName);
        if (instance == null) {
            return;
        }
        instance.shutdownInstance();
        instances.remove(containerName);
    }

    public static void shutdown() {
        PluginContainer.shutdown(MAIN_PLUGIN_CONTAINER_NAME);
    }

    public static void shutdownAll() {
        for (PluginContainer instance : instances.values()) {
            instance.shutdownInstance();
        }
        instances.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownInstance() {
        long begin = System.nanoTime();
        this.loader.notifyShutdown();
        log.info((Object)"Interrupting loader thread...");
        this.loaderThread.interrupt();
        PluginContainer pluginContainer = this;
        synchronized (pluginContainer) {
            try {
                this.loaderThread.join(10000L);
            }
            catch (InterruptedException ie) {
                log.info((Object)"Interrupted while waiting for plugin loader thread to die.");
            }
        }
        this.loaderThread = null;
        long middle = System.nanoTime();
        this.classNameMap.clear();
        this.pluginNameMap.clear();
        this.pluginDirToPluginSetMap.clear();
        this.classNameMap = new HashMap<String, PluginDescriptor>();
        this.notifier.notifyListeners(new PluginEvent(PluginEvent.PluginEventType.UNREGISTER_PLUGIN, null, null));
        this.notifier.clear();
        this.notifier = null;
        this.classNameMap = null;
        this.pluginNameMap = null;
        this.pluginDirToPluginSetMap = null;
        log.info((Object)"All resources released.");
        this.loader.destroy();
        this.loader = null;
        if (this.runGcOnShutdown) {
            System.gc();
            System.runFinalization();
        }
        long end = System.nanoTime();
        String msMiddle = String.valueOf((double)(middle - begin) / 1000000.0);
        String msTotal = String.valueOf((double)(end - begin) / 1000000.0);
        log.info((Object)("PluginContainer finished (" + msMiddle + "ms/" + msTotal + "ms)."));
    }
}

