/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.hotdeploy.PluginContainer;
import ch.ethz.cisd.hotdeploy.PluginDescriptor;
import ch.ethz.cisd.hotdeploy.PluginEvent;
import ch.ethz.cisd.hotdeploy.PluginEventListener;
import ch.ethz.cisd.hotdeploy.PluginEventNotifier;
import ch.ethz.cisd.hotdeploy.ReflectionUtils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginMapHolder<T> {
    private static final Log log = LogFactory.getLog(PluginMapHolder.class);
    private PluginContainer container;
    final Class<T> workerInterface;
    private final Map<String, T> instanceMap;
    private final boolean isClassName;
    private final Class<?>[][] constructorTypeAlternatives;
    private final Object[][] constructorArgsAlternatives;
    private final PluginEventNotifier notifier;

    public PluginMapHolder(PluginContainer container, Class<T> workerInterface, Object ... constructorArgs) {
        this(container, workerInterface, false, new Object[][]{constructorArgs});
    }

    public PluginMapHolder(PluginContainer container, Class<T> workerInterface, boolean useClassNames, Object ... constructorArgs) {
        this(container, workerInterface, useClassNames, new Object[][]{constructorArgs});
    }

    public PluginMapHolder(PluginContainer container, Class<T> workerInterface, Object[][] constructorArgsAlternatives) {
        this(container, workerInterface, false, constructorArgsAlternatives);
    }

    public PluginMapHolder(PluginContainer container, final Class<T> workerInterface, final boolean useClassnames, Object[][] constructorArgsAlternatives) {
        this.container = container;
        this.workerInterface = workerInterface;
        this.instanceMap = Collections.synchronizedMap(new HashMap());
        this.isClassName = useClassnames;
        this.constructorArgsAlternatives = constructorArgsAlternatives;
        this.constructorTypeAlternatives = PluginMapHolder.toTypes(constructorArgsAlternatives);
        this.notifier = new PluginEventNotifier();
        container.addListener(new PluginEventListener(){

            @Override
            public void pluginChanged(PluginEvent event) {
                if (event.isShutdownEvent()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Clear plugin map");
                    }
                    PluginMapHolder.this.instanceMap.clear();
                    return;
                }
                if (event.getPluginClass() != null && workerInterface.isAssignableFrom(event.getPluginClass())) {
                    String key;
                    String string = key = useClassnames ? event.getPluginClassname() : event.getPluginName();
                    if (event.isRegistrationOrUpdateEvent()) {
                        Object instance = PluginMapHolder.this.create(event.getPluginClassname());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Set new plugin instance for plugin  " + key));
                        }
                        PluginMapHolder.this.instanceMap.put(key, instance);
                    } else if (event.isUnregistrationEvent()) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Remove plugin instance for plugin " + key));
                        }
                        PluginMapHolder.this.instanceMap.remove(key);
                    }
                    PluginMapHolder.this.notifier.notifyListeners(event);
                }
            }
        });
        for (PluginDescriptor p : container.getPlugins()) {
            String key;
            if (!p.isImplementing(workerInterface)) continue;
            T instance = this.create(p.getPluginClassname());
            String string = key = useClassnames ? p.getPluginClassname() : p.getPluginName();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set new plugin instance for plugin  " + key));
            }
            this.instanceMap.put(key, instance);
        }
    }

    private static Class<?>[][] toTypes(Object[][] constructorArgsAlternatives) {
        Class[][] types = new Class[constructorArgsAlternatives.length][];
        int idx = 0;
        for (Object[] constructorArgs : constructorArgsAlternatives) {
            types[idx++] = ReflectionUtils.getClasses(constructorArgs);
        }
        return types;
    }

    private T create(String pluginClassName) {
        for (int i = 0; i < this.constructorTypeAlternatives.length; ++i) {
            if (!this.container.hasConstructorByClassname(pluginClassName, this.constructorTypeAlternatives[i])) continue;
            return this.container.tryCreatePluginByClassname(pluginClassName, this.workerInterface, this.constructorArgsAlternatives[i]);
        }
        throw new IllegalArgumentException("No suitable constructor found for plugin pluginClassName");
    }

    public void addListener(PluginEventListener listener) {
        this.notifier.addListener(listener);
    }

    public void removeListener(PluginEventListener listener) {
        this.notifier.removeListener(listener);
    }

    public T tryGet(String name) {
        return this.instanceMap.get(name);
    }

    public Set<String> getPluginNames() {
        return this.instanceMap.keySet();
    }

    public byte[] tryGetResource(String pluginName, String resource) {
        File pluginArchive = this.isClassName ? this.container.tryGetPluginArchiveByClassname(pluginName) : this.container.tryGetPluginArchive(pluginName);
        return this.container.tryGetPluginResource(pluginArchive, resource);
    }

    public void refresh(boolean synchronous) {
        this.container.refresh(synchronous);
    }
}

