/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

final class ReflectionUtils {
    static <T, C> T create(Class<T> workerInterface, Class<C> clazz, Object ... arguments) {
        assert (workerInterface != null) : "Missing worker interface";
        assert (clazz != null) : "Missing class name";
        try {
            if (arguments == null || arguments.length == 0) {
                return ReflectionUtils.cast(clazz.newInstance(), workerInterface);
            }
            Class<?>[] classes = ReflectionUtils.getClasses(arguments);
            Constructor<T> constructor = ReflectionUtils.tryGetConstructor(clazz, classes);
            if (constructor == null) {
                throw new IllegalArgumentException(String.format("Cannot instantiate class '%s' with given arguments '%s' (constructor not found).", clazz.getName(), Arrays.asList(arguments)));
            }
            T instance = ReflectionUtils.cast(constructor.newInstance(arguments), workerInterface);
            return instance;
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(String.format("Cannot instantiate class '%s' with given arguments '%s' (class is non-instantiable).", clazz.getName(), Arrays.asList(arguments)));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(String.format("Cannot instantiate class '%s' with given arguments '%s' (access violation).", clazz.getName(), Arrays.asList(arguments)));
        }
        catch (InvocationTargetException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Throwable)ex.getCause());
        }
    }

    private static <T> T cast(Object instance, Class<T> workerInterface) {
        if (!workerInterface.isInstance(instance)) {
            throw new ClassCastException(String.format("Class '%s' does not implement interface '%s'.", instance.getClass().getName(), workerInterface.getName()));
        }
        return (T)instance;
    }

    static Class<?>[] getClasses(Object ... initargs) {
        Class[] classes = new Class[initargs.length];
        int i = 0;
        for (Object initarg : initargs) {
            classes[i++] = initarg.getClass();
        }
        return classes;
    }

    static <T> Constructor<T> tryGetConstructor(Class<?> clazz, Class<?>[] classes) {
        Constructor<?>[] constructors = clazz.getConstructors();
        Constructor<?> returned = null;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int len = parameterTypes.length;
            if (len != classes.length) continue;
            boolean match = true;
            for (int i = 0; i < len; ++i) {
                Class<?> parameterType = parameterTypes[i];
                Class<?> c = classes[i];
                match &= parameterType.equals(c) || parameterType.isAssignableFrom(c);
            }
            if (!match) continue;
            returned = constructor;
        }
        return ReflectionUtils.toGenericType(returned);
    }

    private static <T> Constructor<T> toGenericType(Constructor<?> returned) {
        return returned;
    }

    private ReflectionUtils() {
    }
}

