/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.cisd.hotdeploy;

import ch.ethz.cisd.compile.SimpleJavaCompiler;
import ch.ethz.cisd.hotdeploy.PluginTester;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.apache.commons.io.FileUtils;

public class ScriptPluginTester
implements Closeable {
    private final SimpleJavaCompiler compiler;
    private final boolean requirePluginInfo;
    private PluginTester tester;

    public ScriptPluginTester() {
        this(null, false);
    }

    public ScriptPluginTester(File tempRootDirectory) {
        this(tempRootDirectory, false);
    }

    public ScriptPluginTester(boolean requirePluginInfo) {
        this(null, requirePluginInfo);
    }

    public ScriptPluginTester(File tempRootDirectory, boolean requirePluginInfo) {
        this.compiler = new SimpleJavaCompiler(tempRootDirectory);
        this.requirePluginInfo = requirePluginInfo;
    }

    public String getLastClassName() {
        return this.compiler.getLastClassName();
    }

    public List<String> getCompilerOptions() {
        return this.compiler.getCompilerOptions();
    }

    public List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.compiler.getDiagnostics();
    }

    public String getErrorMessage() {
        return this.compiler.getErrorMessage();
    }

    public JavaFileObject tryGetFileObjectFromSourceCode(String classSource) {
        return this.compiler.tryGetFileObjectFromSourceCode(classSource);
    }

    public JavaFileObject tryGetFileObjectFromSourceCode(String classNameOrNull, String classSource) {
        return this.compiler.tryGetFileObjectFromSourceCode(classNameOrNull, classSource);
    }

    public JavaFileObject tryGetFileObjectForFile(File javaFile) {
        return this.compiler.tryGetFileObjectForFile(javaFile);
    }

    public Iterable<? extends JavaFileObject> getFileObjectsForDirectory(File directory) {
        return this.compiler.getFileObjectsForDirectory(directory);
    }

    public boolean compile(Iterable<? extends JavaFileObject> fileObjects) throws IOExceptionUnchecked {
        this.checkTesterNull();
        return this.compiler.compile(fileObjects);
    }

    public boolean compile(JavaFileObject ... fileObjects) throws IOExceptionUnchecked {
        this.checkTesterNull();
        return this.compiler.compile(fileObjects);
    }

    public void addFile(File source, String destPath) throws IOExceptionUnchecked {
        this.checkTesterNull();
        this.compiler.addFile(source, destPath);
    }

    public void addContent(InputStream istream, String destPath) throws IOExceptionUnchecked {
        this.checkTesterNull();
        this.compiler.addContent(istream, destPath);
    }

    public PluginTester tryLoadPlugin() {
        this.checkTesterNull();
        File pluginArchive = this.compiler.tryCreateJar(this.compiler.getTempDir());
        return this.tryCreatePluginTester(pluginArchive);
    }

    public PluginTester tryCompileAndLoadFromFiles(File sourceDirectory) throws IOExceptionUnchecked {
        this.checkTesterNull();
        Iterable<? extends JavaFileObject> fileObjects = this.getFileObjectsForDirectory(sourceDirectory);
        if (!this.compile(fileObjects)) {
            return null;
        }
        File pluginArchive = this.compiler.tryCreateJar(this.compiler.getTempDir());
        return this.tryCreatePluginTester(pluginArchive);
    }

    public <T> T tryCompileAndCreateFromFiles(File sourceDirectory, Class<T> workerInterface, Object ... constructorArguments) throws IOExceptionUnchecked {
        this.checkTesterNull();
        Iterable<? extends JavaFileObject> fileObjects = this.getFileObjectsForDirectory(sourceDirectory);
        if (!this.compile(fileObjects)) {
            return null;
        }
        File pluginArchive = this.compiler.tryCreateJar(this.compiler.getTempDir());
        if (this.tryCreatePluginTester(pluginArchive) == null) {
            return null;
        }
        return this.tester.tryCreatePlugin(workerInterface, constructorArguments);
    }

    public PluginTester tryCompileAndLoadFromString(String classSource) throws IOExceptionUnchecked {
        this.checkTesterNull();
        JavaFileObject fileObject = this.tryGetFileObjectFromSourceCode(classSource);
        if (fileObject == null) {
            return null;
        }
        if (!this.compile(fileObject)) {
            return null;
        }
        File pluginArchive = this.compiler.tryCreateJar(this.compiler.getTempDir());
        return this.tryCreatePluginTester(pluginArchive);
    }

    public <T> T tryCompileAndCreateFromString(String classSource, Class<T> workerInterface, Object ... constructorArguments) throws IOExceptionUnchecked {
        this.checkTesterNull();
        JavaFileObject fileObject = this.tryGetFileObjectFromSourceCode(classSource);
        if (fileObject == null) {
            return null;
        }
        if (!this.compile(fileObject)) {
            return null;
        }
        File pluginArchive = this.compiler.tryCreateJar(this.compiler.getTempDir());
        if (this.tryCreatePluginTester(pluginArchive) == null) {
            return null;
        }
        return this.tester.tryCreatePlugin(workerInterface, constructorArguments);
    }

    public PluginTester getPluginTester() {
        if (this.tester == null) {
            throw new IllegalStateException("Cannot return the plugin tester before it has been been created.");
        }
        return this.tester;
    }

    public File copyPluginJar(File destinationDir) throws IOExceptionUnchecked {
        return this.copyPluginJar(destinationDir, null);
    }

    public File copyPluginJar(File destinationDir, String name) throws IOExceptionUnchecked {
        if (this.tester == null) {
            throw new IllegalStateException("Cannot copy the jar file before it has been created.");
        }
        File destFile = name == null ? new File(destinationDir, this.tester.getPluginArchive().getName()) : new File(destinationDir, name);
        try {
            FileUtils.copyFile((File)this.tester.getPluginArchive(), (File)destFile);
            return destFile;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    private void checkTesterNull() {
        if (this.tester != null) {
            throw new IllegalStateException("Cannot change compilation units after plugin has been created.");
        }
    }

    private PluginTester tryCreatePluginTester(File pluginArchive) {
        if (pluginArchive == null) {
            this.compiler.getLogWriter().write("Error creating jar file.");
            return null;
        }
        try {
            this.tester = new PluginTester(pluginArchive, this.compiler.getLogWriter(), this.requirePluginInfo);
        }
        catch (IllegalArgumentException ex) {
            this.compiler.getLogWriter().write("Error loading plugin: jar file does not contain a valid plugin.");
        }
        return this.tester;
    }

    @Override
    public void close() throws IOExceptionUnchecked {
        if (this.tester != null) {
            this.tester.close();
        }
        this.compiler.close();
    }
}

