/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.utils;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import org.apache.log4j.Logger;

public class LogUtils {
    private static final Logger notificationLog = LogFactory.getLogger((LogCategory)LogCategory.NOTIFY, LogUtils.class);
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, LogUtils.class);

    public static void notify(EnvironmentFailureException ex) {
        String causeMsg = ex.getCause() == null ? "" : "Error cause: " + ex.getCause().getMessage();
        String fullMsg = "An environment exception occured while trying to send emails with changes.\nCheck and correct the configuration.\nError details: " + ex.getMessage() + "\n" + causeMsg;
        LogUtils.notify(ex, fullMsg);
    }

    public static void notify(Throwable ex) {
        String fullMsg = "An unexpected exception occured why trying to send emails with changes.\nError details: " + ex.getMessage();
        LogUtils.notify(ex, fullMsg);
    }

    private static void notify(Throwable ex, String fullMsg) {
        ex.printStackTrace();
        notificationLog.error((Object)fullMsg);
    }

    public static EnvironmentFailureException environmentError(String message, Throwable exception) {
        String fullMsg = String.valueOf(message) + " The following exception has been thrown: " + exception.getMessage();
        return new EnvironmentFailureException(fullMsg, exception);
    }

    public static EnvironmentFailureException environmentError(String msgFormat, Object ... params) {
        String fullMsg = String.format(msgFormat, params);
        return new EnvironmentFailureException(fullMsg);
    }

    public static void info(String msg) {
        operationLog.info((Object)msg);
    }

    public static void debug(String msg) {
        operationLog.debug((Object)msg);
    }
}

