/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TileJPEGReader;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;

public class HamamatsuVMSReader
extends FormatReader {
    private ArrayList<String> files = new ArrayList();
    private String[][][] tileFiles;
    private TileJPEGReader[] jpeg;

    public HamamatsuVMSReader() {
        super("Hamamatsu VMS", "vms");
        this.domains = new String[]{"Histology"};
        this.datasetDescription = "One .vms file plus several .jpg files";
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.currentId};
        }
        ArrayList<String> f = new ArrayList<String>();
        f.add(this.jpeg[this.getSeries()].getCurrentFile());
        f.addAll(this.files);
        return f.toArray(new String[f.size()]);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.jpeg[this.getSeries()].openBytes(no, buf, x, y, w, h);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tileFiles = null;
            this.files.clear();
            if (this.jpeg != null) {
                for (TileJPEGReader j : this.jpeg) {
                    if (j == null) continue;
                    j.close();
                }
                this.jpeg = null;
            }
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        IniParser parser = new IniParser();
        IniList layout = parser.parseINI(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(id), "UTF-8")));
        IniTable slideInfo = layout.getTable("Virtual Microscope Specimen");
        int nLayers = Integer.parseInt((String)slideInfo.get("NoLayers"));
        int nRows = Integer.parseInt((String)slideInfo.get("NoJpegRows"));
        int nCols = Integer.parseInt((String)slideInfo.get("NoJpegColumns"));
        String imageFile = (String)slideInfo.get("ImageFile");
        String mapFile = (String)slideInfo.get("MapFile");
        String optimisationFile = (String)slideInfo.get("OptimisationFile");
        String macroFile = (String)slideInfo.get("MacroImage");
        Double physicalWidth = new Double((String)slideInfo.get("PhysicalWidth"));
        Double physicalHeight = new Double((String)slideInfo.get("PhysicalHeight"));
        Double magnification = new Double((String)slideInfo.get("SourceLens"));
        Double macroWidth = new Double((String)slideInfo.get("PhysicalMacroWidth"));
        Double macroHeight = new Double((String)slideInfo.get("PhysicalMacroHeight"));
        for (String key : slideInfo.keySet()) {
            this.addGlobalMeta(key, slideInfo.get(key));
        }
        Location dir = new Location(id).getAbsoluteFile().getParentFile();
        this.tileFiles = new String[nLayers][nRows][nCols];
        for (int layer = 0; layer < nLayers; ++layer) {
            for (int row = 0; row < nRows; ++row) {
                for (int col = 0; col < nCols; ++col) {
                    this.tileFiles[layer][row][col] = (String)slideInfo.get("ImageFile(" + col + "," + row + ")");
                    if (this.tileFiles[layer][row][col] == null) continue;
                    this.files.add(new Location(dir, this.tileFiles[layer][row][col]).getAbsolutePath());
                }
            }
        }
        if (imageFile != null) {
            imageFile = new Location(dir, imageFile).getAbsolutePath();
        }
        if (mapFile != null) {
            mapFile = new Location(dir, mapFile).getAbsolutePath();
        }
        if (optimisationFile != null) {
            optimisationFile = new Location(dir, optimisationFile).getAbsolutePath();
            this.files.add(optimisationFile);
        }
        if (macroFile != null) {
            macroFile = new Location(dir, macroFile).getAbsolutePath();
        }
        this.jpeg = new TileJPEGReader[3];
        this.core = new CoreMetadata[3];
        for (int i = 0; i < this.core.length; ++i) {
            String file2 = null;
            switch (i) {
                case 0: {
                    file2 = imageFile;
                    break;
                }
                case 1: {
                    file2 = macroFile;
                    break;
                }
                case 2: {
                    file2 = mapFile;
                }
            }
            this.jpeg[i] = new TileJPEGReader();
            this.jpeg[i].setId(file2);
            this.core[i] = this.jpeg[i].getCoreMetadata()[0];
            this.core[i].thumbnail = i > 0;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        String path = new Location(this.currentId).getAbsoluteFile().getName();
        store.setImageName(path + " full resolution", 0);
        store.setImageName(path + " macro", 1);
        store.setImageName(path + " map", 2);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            PositiveFloat sizeX = FormatTools.getPhysicalSizeX(physicalWidth / (double)this.core[0].sizeX);
            PositiveFloat sizeY = FormatTools.getPhysicalSizeY(physicalHeight / (double)this.core[0].sizeY);
            PositiveFloat macroSizeX = FormatTools.getPhysicalSizeX(macroWidth / (double)this.core[1].sizeX);
            PositiveFloat macroSizeY = FormatTools.getPhysicalSizeY(macroHeight / (double)this.core[1].sizeY);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (macroSizeX != null) {
                store.setPixelsPhysicalSizeX(macroSizeX, 1);
            }
            if (macroSizeY != null) {
                store.setPixelsPhysicalSizeY(macroSizeY, 1);
            }
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            if (magnification > 0.0) {
                store.setObjectiveNominalMagnification(new PositiveInteger(magnification.intValue()), 0, 0);
            } else {
                LOGGER.warn("Expected positive value for NominalMagnification; got {}", magnification);
            }
            store.setObjectiveSettingsID(objectiveID, 0);
        }
    }
}

