/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.BufferedImageWriter;
import loci.formats.meta.IMetadata;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.OMETiffWriter;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.EnumerationException;

public class MakeTestOmeTiff {
    public void makeSamples() throws FormatException, IOException {
        this.makeOmeTiff("single-channel", "439", "167", "1", "1", "1", "XYZCT");
        this.makeOmeTiff("multi-channel", "439", "167", "1", "3", "1", "XYZCT");
        this.makeOmeTiff("z-series", "439", "167", "5", "1", "1", "XYZCT");
        this.makeOmeTiff("multi-channel-z-series", "439", "167", "5", "3", "1", "XYZCT");
        this.makeOmeTiff("time-series", "439", "167", "1", "1", "7", "XYZCT");
        this.makeOmeTiff("multi-channel-time-series", "439", "167", "1", "3", "7", "XYZCT");
        this.makeOmeTiff("4D-series", "439", "167", "5", "1", "7", "XYZCT");
        this.makeOmeTiff("multi-channel-4D-series", "439", "167", "5", "3", "7", "XYZCT");
    }

    public int makeOmeTiff(String ... args) throws FormatException, IOException {
        if (args == null || args.length == 0) {
            this.makeSamples();
            return 0;
        }
        if (args.length != 7) {
            this.displayUsage();
            return 1;
        }
        String name = args[0];
        CoreMetadata info = new CoreMetadata();
        info.sizeX = Integer.parseInt(args[1]);
        info.sizeY = Integer.parseInt(args[2]);
        info.sizeZ = Integer.parseInt(args[3]);
        info.sizeC = Integer.parseInt(args[4]);
        info.sizeT = Integer.parseInt(args[5]);
        info.imageCount = info.sizeZ * info.sizeC * info.sizeT;
        info.dimensionOrder = args[6].toUpperCase();
        this.makeOmeTiff(name, info);
        return 0;
    }

    public void makeOmeTiff(String name, CoreMetadata info) throws FormatException, IOException {
        String id = this.getId(name);
        OMETiffWriter out = this.createWriter(name, info, id);
        this.writeData(name, info, id, out);
    }

    public static void main(String[] args) throws FormatException, IOException {
        int returnCode = new MakeTestOmeTiff().makeOmeTiff(args);
        System.exit(returnCode);
    }

    private void displayUsage() {
        System.out.println("Usage: java loci.formats.tools.MakeTestOmeTiff name");
        System.out.println("           SizeX SizeY SizeZ SizeC SizeT DimOrder");
        System.out.println();
        System.out.println("  name: output filename");
        System.out.println("  SizeX: width of image planes");
        System.out.println("  SizeY: height of image planes");
        System.out.println("  SizeZ: number of focal planes");
        System.out.println("  SizeC: number of channels");
        System.out.println("  SizeT: number of time points");
        System.out.println("  DimOrder: planar ordering:");
        System.out.println("    XYZCT, XYZTC, XYCZT, XYCTZ, XYTZC, or XYTCZ");
        System.out.println();
        System.out.println("Example:");
        System.out.println("  java loci.formats.tools.MakeTestOmeTiff test \\");
        System.out.println("    517 239 5 3 4 XYCZT");
    }

    private String getId(String name) {
        String id = name.toLowerCase().endsWith(".ome.tif") ? name : name + ".ome.tif";
        return id;
    }

    private OMETiffWriter createWriter(String name, CoreMetadata info, String id) throws FormatException, IOException {
        OMETiffWriter out = new OMETiffWriter();
        try {
            out.setMetadataRetrieve(this.createMetadata(name, info));
        }
        catch (DependencyException e) {
            throw new FormatException(e);
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        catch (EnumerationException e) {
            throw new FormatException(e);
        }
        this.ensureNonExisting(id);
        out.setId(id);
        return out;
    }

    private void writeData(String name, CoreMetadata info, String id, OMETiffWriter out) throws FormatException, IOException {
        System.out.print(id);
        for (int i = 0; i < info.imageCount; ++i) {
            BufferedImage plane = this.createPlane(name, info, i);
            out.saveBytes(i, BufferedImageWriter.toBytes(plane, out));
            System.out.print(".");
        }
        System.out.println();
        out.close();
    }

    private void ensureNonExisting(String id) {
        File idFile = new File(id);
        if (idFile.exists()) {
            idFile.delete();
        }
    }

    private IMetadata createMetadata(String name, CoreMetadata info) throws DependencyException, ServiceException, EnumerationException {
        ServiceFactory serviceFactory = new ServiceFactory();
        OMEXMLService omexmlService = serviceFactory.getInstance(OMEXMLService.class);
        OMEXMLMetadata meta = omexmlService.createOMEXMLMetadata();
        MetadataTools.populateMetadata(meta, 0, name, info);
        return meta;
    }

    private BufferedImage createPlane(String name, CoreMetadata info, int no) {
        int[] zct = FormatTools.getZCTCoords(info.dimensionOrder, info.sizeZ, info.sizeC, info.sizeT, info.imageCount, no);
        BufferedImage plane = new BufferedImage(info.sizeX, info.sizeY, 10);
        Graphics2D g = plane.createGraphics();
        boolean type = false;
        for (int y = 0; y < info.sizeY; ++y) {
            int v = this.gradient(0, y, info.sizeY);
            g.setColor(new Color(v, v, v));
            g.drawLine(0, y, info.sizeX, y);
        }
        ArrayList<TextLine> lines = new ArrayList<TextLine>();
        Font font = g.getFont();
        lines.add(new TextLine(name, font.deriveFont(32.0f), 5, -5));
        lines.add(new TextLine(info.sizeX + " x " + info.sizeY, font.deriveFont(2, 16.0f), 20, 10));
        lines.add(new TextLine(info.dimensionOrder, font.deriveFont(2, 14.0f), 30, 5));
        int space = 5;
        if (info.sizeZ > 1) {
            lines.add(new TextLine("Focal plane = " + (zct[0] + 1) + "/" + info.sizeZ, font, 20, space));
            space = 2;
        }
        if (info.sizeC > 1) {
            lines.add(new TextLine("Channel = " + (zct[1] + 1) + "/" + info.sizeC, font, 20, space));
            space = 2;
        }
        if (info.sizeT > 1) {
            lines.add(new TextLine("Time point = " + (zct[2] + 1) + "/" + info.sizeT, font, 20, space));
            space = 2;
        }
        g.setColor(Color.white);
        int yoff = 0;
        for (int l = 0; l < lines.size(); ++l) {
            TextLine text = (TextLine)lines.get(l);
            g.setFont(text.font);
            Rectangle2D r = g.getFont().getStringBounds(text.line, g.getFontRenderContext());
            yoff = (int)((double)yoff + (r.getHeight() + (double)text.ypad));
            g.drawString(text.line, text.xoff, yoff);
        }
        g.dispose();
        return plane;
    }

    private int gradient(int type, int num, int total) {
        int max = 96;
        int split = type / 2 + 1;
        boolean reverse = type % 2 == 0;
        int v = 96;
        int splitTotal = total / split;
        for (int i = 1; i <= split + 1; ++i) {
            if (num >= i * splitTotal) continue;
            if (i % 2 == 0) {
                v = 96 * (num % splitTotal) / splitTotal;
                break;
            }
            v = 96 * (splitTotal - num % splitTotal) / splitTotal;
            break;
        }
        if (reverse) {
            v = 96 - v;
        }
        return v;
    }

    private static class TextLine {
        final String line;
        final Font font;
        final int xoff;
        final int ypad;

        TextLine(String line, Font font, int xoff, int ypad) {
            this.line = line;
            this.font = font;
            this.xoff = xoff;
            this.ypad = ypad;
        }
    }
}

