/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.Shape;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Ellipse
extends Shape {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/ROI/2012-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Ellipse.class);
    private Double y;
    private Double x;
    private Double radiusY;
    private Double radiusX;

    public Ellipse() {
    }

    public Ellipse(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        String tagName = element.getTagName();
        if (!"Ellipse".equals(tagName)) {
            LOGGER.debug("Expecting node name of Ellipse got {}", (Object)tagName);
        }
        if (element.hasAttribute("Y")) {
            this.setY(Double.valueOf(element.getAttribute("Y")));
        }
        if (element.hasAttribute("X")) {
            this.setX(Double.valueOf(element.getAttribute("X")));
        }
        if (element.hasAttribute("RadiusY")) {
            this.setRadiusY(Double.valueOf(element.getAttribute("RadiusY")));
        }
        if (element.hasAttribute("RadiusX")) {
            this.setRadiusX(Double.valueOf(element.getAttribute("RadiusX")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        boolean wasHandledBySuperClass = super.link(reference, o);
        if (wasHandledBySuperClass) {
            return true;
        }
        LOGGER.debug("Unable to handle reference of type: {}", reference.getClass());
        return false;
    }

    public Double getY() {
        return this.y;
    }

    public void setY(Double y) {
        this.y = y;
    }

    public Double getX() {
        return this.x;
    }

    public void setX(Double x) {
        this.x = x;
    }

    public Double getRadiusY() {
        return this.radiusY;
    }

    public void setRadiusY(Double radiusY) {
        this.radiusY = radiusY;
    }

    public Double getRadiusX() {
        return this.radiusX;
    }

    public void setRadiusX(Double radiusX) {
        this.radiusX = radiusX;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    protected Element asXMLElement(Document document, Element Ellipse_element) {
        if (Ellipse_element == null) {
            Ellipse_element = document.createElementNS(NAMESPACE, "Ellipse");
        }
        if (this.y != null) {
            Ellipse_element.setAttribute("Y", this.y.toString());
        }
        if (this.x != null) {
            Ellipse_element.setAttribute("X", this.x.toString());
        }
        if (this.radiusY != null) {
            Ellipse_element.setAttribute("RadiusY", this.radiusY.toString());
        }
        if (this.radiusX != null) {
            Ellipse_element.setAttribute("RadiusX", this.radiusX.toString());
        }
        return super.asXMLElement(document, Ellipse_element);
    }
}

