/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.postregistration;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FastRecursiveHardLinkMaker;
import ch.systemsx.cisd.common.filesystem.IImmutableCopier;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.etlserver.postregistration.AbstractPostRegistrationTask;
import ch.systemsx.cisd.etlserver.postregistration.ICleanupTask;
import ch.systemsx.cisd.etlserver.postregistration.IPostRegistrationTaskExecutor;
import ch.systemsx.cisd.etlserver.postregistration.NoCleanupTask;
import ch.systemsx.cisd.openbis.dss.etl.dataaccess.IImagingQueryDAO;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.plugin.screening.server.logic.ScreeningUtils;
import java.io.File;
import java.util.Properties;
import javax.sql.DataSource;
import net.lemnik.eodsql.QueryTool;
import org.apache.log4j.Logger;

public class RedoSegmentationOnFailureTask
extends AbstractPostRegistrationTask {
    private final File storeRoot;
    private final IImagingQueryDAO dao;
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, RedoSegmentationOnFailureTask.class);

    public RedoSegmentationOnFailureTask(Properties properties, IEncapsulatedOpenBISService service) {
        super(properties, service);
        DataSource dataSource = ServiceProvider.getDataSourceProvider().getDataSource(properties);
        this.dao = (IImagingQueryDAO)QueryTool.getQuery((DataSource)dataSource, IImagingQueryDAO.class);
        this.dao.listSpots(0L);
        this.storeRoot = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider().getStoreRoot();
        if (!this.storeRoot.isDirectory()) {
            throw new ConfigurationFailureException("Store root does not exist or is not a directory: ");
        }
    }

    public boolean requiresDataStoreLock() {
        return true;
    }

    public IPostRegistrationTaskExecutor createExecutor(String dataSetCode, boolean container) {
        return new Executor(dataSetCode);
    }

    private class Executor
    implements IPostRegistrationTaskExecutor {
        private String dataSetCode;

        public Executor(String dataSetCode) {
            this.dataSetCode = dataSetCode;
        }

        private String tryExtractLocation(AbstractExternalData data) {
            for (AbstractExternalData containedDataSet : data.tryGetAsContainerDataSet().getContainedDataSets()) {
                if (containedDataSet.getDataSetType().getCode().contains("OVERVIEW")) continue;
                return containedDataSet.tryGetAsDataSet().getLocation();
            }
            return null;
        }

        public void execute() {
            AbstractExternalData data = RedoSegmentationOnFailureTask.this.service.tryGetDataSet(this.dataSetCode);
            if (data.isContainer() && ScreeningUtils.isSegmentationHcsImageDataset((AbstractExternalData)data) && RedoSegmentationOnFailureTask.this.dao.tryGetImageDatasetByPermId(data.getCode()) == null) {
                File dataSetDir = this.extractDataSetFile(data);
                if (dataSetDir != null) {
                    operationLog.info((Object)("Bad segmentation dataset found " + this.dataSetCode));
                }
                File dropboxDir = this.extractDropboxDir();
                if (dataSetDir != null && dropboxDir != null) {
                    this.makeHardlinkCopy(dataSetDir, dropboxDir);
                }
            }
        }

        private File extractDropboxDir() {
            String dropboxPath = RedoSegmentationOnFailureTask.this.properties.getProperty("dropbox-path");
            if (dropboxPath == null) {
                operationLog.error((Object)"Property 'dropbox-path' must be specified for this task");
                return null;
            }
            File dropboxDir = new File(dropboxPath);
            if (!dropboxDir.exists() || !dropboxDir.isDirectory()) {
                operationLog.error((Object)"Property 'dropbox-path' must point to an existing directory");
                return null;
            }
            return dropboxDir;
        }

        private File extractDataSetFile(AbstractExternalData data) {
            String location = this.tryExtractLocation(data);
            if (location == null) {
                operationLog.error((Object)("Couldn't extract original location of the dataset " + this.dataSetCode));
                return null;
            }
            File dataSetDir = new File(RedoSegmentationOnFailureTask.this.storeRoot, location);
            if (!dataSetDir.exists()) {
                operationLog.error((Object)("Error occured. The data set not present under " + dataSetDir.getAbsolutePath()));
                return null;
            }
            return this.descendIntoOriginalDirectory(dataSetDir);
        }

        private File descendIntoOriginalDirectory(File directory) {
            File[] dirContents;
            File[] fileArray = dirContents = directory.listFiles();
            int n = dirContents.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.getName().equals("original") && f.isDirectory()) {
                    return this.descendIntoOriginalDirectory(f);
                }
                ++n2;
            }
            return directory;
        }

        private boolean makeHardlinkCopy(File inputFile, File destinationDirectory) {
            IImmutableCopier hardlinkMaker = FastRecursiveHardLinkMaker.tryCreate();
            boolean linkWasMade = false;
            if (hardlinkMaker != null) {
                Status status = hardlinkMaker.copyImmutably(inputFile, destinationDirectory, null);
                linkWasMade = status.isOK();
            }
            return linkWasMade;
        }

        public ICleanupTask createCleanupTask() {
            return new NoCleanupTask();
        }
    }
}

