/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.demo;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DemoArchiver
extends AbstractArchiverProcessingPlugin {
    private static final long serialVersionUID = 1L;
    private static final Set<String> archiveContents = new HashSet<String>();

    public DemoArchiver(Properties properties, File storeRoot) {
        super(properties, storeRoot, null, null);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> datasets, ArchiverTaskContext context) throws UserFailureException {
        operationLog.info((Object)("DemoArchiver - Archived: " + datasets));
        archiveContents.addAll(DatasetDescription.extractCodes(datasets));
        return DemoArchiver.createStatuses(Status.OK, datasets, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) throws UserFailureException {
        operationLog.info((Object)("DemoArchiver - Unarchived: " + datasets));
        return DemoArchiver.createStatuses(Status.OK, datasets, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
    }

    @Override
    public BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        boolean present = archiveContents.contains(dataset.getDataSetCode());
        return BooleanStatus.createFromBoolean(present);
    }

    @Override
    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataset) {
        boolean present = archiveContents.contains(dataset.getDataSetCode());
        return BooleanStatus.createFromBoolean(present);
    }

    @Override
    public AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> dataSets) {
        ArrayList<String> datasetCodes = new ArrayList<String>();
        for (IDatasetLocation iDatasetLocation : dataSets) {
            datasetCodes.add(iDatasetLocation.getDataSetCode());
        }
        archiveContents.addAll(datasetCodes);
        operationLog.info((Object)("DemoArchiver - deleteFromArchive: " + datasetCodes));
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses datasetProcessingStatuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (String dataset : datasetCodes) {
            datasetProcessingStatuses.addResult(dataset, Status.OK, AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE);
        }
        return datasetProcessingStatuses;
    }

    @Override
    protected void removeFromDataStore(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        operationLog.info((Object)("DemoArchiver - removeFromDataStore supressed: " + datasets));
    }
}

