/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.DefaultFileBasedHierarchicalContentFactory;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContentNode;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.DataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IDataSetFileOperationsManager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.RsyncArchiveCopierFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.SshCommandExecutorFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class RsyncArchiver
extends AbstractArchiverProcessingPlugin {
    @Private
    static final String ONLY_MARK_AS_DELETED_KEY = "only-mark-as-deleted";
    @Private
    static final String STAGING_FOLDER = "archive-staging";
    @Private
    static final String VERIFY_CHECKSUMS_KEY = "verify-checksums";
    private static final long serialVersionUID = 1L;
    private static final Comparator<IHierarchicalContentNode> NODE_COMPARATOR = new Comparator<IHierarchicalContentNode>(){

        @Override
        public int compare(IHierarchicalContentNode n1, IHierarchicalContentNode n2) {
            return n1.getName().compareTo(n2.getName());
        }
    };
    private transient IDataSetFileOperationsManager fileOperationsManager;
    private final DeleteAction deleteAction;
    private final ChecksumVerificationCondition checksumVerificationCondition;

    public RsyncArchiver(Properties properties, File storeRoot) {
        this(properties, storeRoot, new DataSetFileOperationsManager(properties, new RsyncArchiveCopierFactory(), new SshCommandExecutorFactory()));
    }

    protected RsyncArchiver(Properties properties, File storeRoot, IDataSetFileOperationsManager fileOperationsManager) {
        this(properties, storeRoot, fileOperationsManager, PropertyUtils.getBoolean(properties, ONLY_MARK_AS_DELETED_KEY, true) ? DeleteAction.MARK_AS_DELETED : DeleteAction.DELETE, PropertyUtils.getBoolean(properties, VERIFY_CHECKSUMS_KEY, true) ? ChecksumVerificationCondition.YES : ChecksumVerificationCondition.NO);
    }

    public RsyncArchiver(Properties properties, File storeRoot, IDataSetFileOperationsManager fileOperationsManager, DeleteAction deleteAction, ChecksumVerificationCondition checksumVerificationCondition) {
        super(properties, storeRoot, null, null);
        this.fileOperationsManager = fileOperationsManager;
        this.deleteAction = deleteAction;
        this.checksumVerificationCondition = checksumVerificationCondition;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> datasets, ArchiverTaskContext context) throws UserFailureException {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            File originalData = this.getDatasetDirectory(context, dataset);
            Status status = this.doArchive(dataset, originalData);
            String dataSetCode = dataset.getDataSetCode();
            if (status.isOK()) {
                IHierarchicalContent content = context.getHierarchicalContentProvider().asContentWithoutModifyingAccessTimestamp(dataSetCode);
                File temp = new File(context.getDirectoryProvider().getStoreRoot(), "archive-staging/" + dataSetCode);
                temp.mkdirs();
                IHierarchicalContent archivedContent = null;
                try {
                    if (this.fileOperationsManager.isHosted()) {
                        this.fileOperationsManager.retrieveFromDestination(temp, dataset);
                        archivedContent = new DefaultFileBasedHierarchicalContentFactory().asHierarchicalContent(temp, null);
                    } else {
                        archivedContent = this.fileOperationsManager.getAsHierarchicalContent(dataset);
                    }
                    IHierarchicalContentNode root = content.getRootNode();
                    IHierarchicalContentNode archivedRoot = archivedContent.getRootNode();
                    status = RsyncArchiver.checkHierarchySizeAndChecksums(root, archivedRoot, this.checksumVerificationCondition);
                }
                finally {
                    content.close();
                    if (archivedContent != null) {
                        archivedContent.close();
                    }
                    FileUtils.deleteQuietly((File)temp);
                }
            }
            statuses.addResult(dataSetCode, status, AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
        }
        return statuses;
    }

    @Private
    static Status checkHierarchySizeAndChecksums(IHierarchicalContentNode node, IHierarchicalContentNode retrievedNode, ChecksumVerificationCondition checksumVerificationCondition) {
        boolean directoryOfRetrieved;
        String relativePathOfRetrieved;
        String relativePath = node.getRelativePath();
        if (!relativePath.equals(relativePathOfRetrieved = retrievedNode.getRelativePath())) {
            return Status.createError("Different paths: Path in the store is '" + relativePath + "' and in the archive '" + relativePathOfRetrieved + "'.");
        }
        boolean directory = node.isDirectory();
        if (directory != (directoryOfRetrieved = retrievedNode.isDirectory())) {
            return Status.createError("The path '" + relativePath + "' should be in store and archive either " + "both directories or files but not mixed: In the store it is a " + RsyncArchiver.render(directory) + " but in the archive it is a " + RsyncArchiver.render(directoryOfRetrieved) + ".");
        }
        if (directory) {
            int sizeOfRetrieved;
            List<IHierarchicalContentNode> childNodes = RsyncArchiver.getChildNodes(node);
            List<IHierarchicalContentNode> childNodesOfRetrieved = RsyncArchiver.getChildNodes(retrievedNode);
            int size = childNodes.size();
            if (size != (sizeOfRetrieved = childNodesOfRetrieved.size())) {
                return Status.createError("The directory '" + relativePath + "' has in the store " + size + " files but " + sizeOfRetrieved + " in the archive.");
            }
            int i = 0;
            while (i < size) {
                Status status = RsyncArchiver.checkHierarchySizeAndChecksums(childNodes.get(i), childNodesOfRetrieved.get(i), checksumVerificationCondition);
                if (status.isError()) {
                    return status;
                }
                ++i;
            }
        } else {
            long checksumOfRetrieved;
            long checksum;
            long fileLengthOfRetrieved;
            long fileLength = node.getFileLength();
            if (fileLength != (fileLengthOfRetrieved = retrievedNode.getFileLength())) {
                return Status.createError("The file '" + relativePath + "' has in the store " + fileLength + " bytes but " + fileLengthOfRetrieved + " in the archive.");
            }
            if (checksumVerificationCondition.verifyChecksum(node) && (checksum = (long)node.getChecksumCRC32()) != (checksumOfRetrieved = (long)retrievedNode.getChecksumCRC32())) {
                return Status.createError("The file '" + relativePath + "' has in the store the checksum " + RsyncArchiver.renderChecksum(checksum) + " but " + RsyncArchiver.renderChecksum(checksumOfRetrieved) + " in the archive.");
            }
        }
        return Status.OK;
    }

    private static List<IHierarchicalContentNode> getChildNodes(IHierarchicalContentNode node) {
        List<IHierarchicalContentNode> childNodes = node.getChildNodes();
        Collections.sort(childNodes, NODE_COMPARATOR);
        return childNodes;
    }

    private static String render(boolean directory) {
        return directory ? "directory" : "file";
    }

    private static String renderChecksum(long checksum) {
        return String.format("%08X", checksum);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) throws UserFailureException {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            context.getUnarchivingPreparation().prepareForUnarchiving(dataset);
            File originalData = this.getDatasetDirectory(context, dataset);
            Status status = this.doUnarchive(dataset, originalData);
            statuses.addResult(dataset.getDataSetCode(), status, AbstractArchiverProcessingPlugin.Operation.UNARCHIVE);
        }
        return statuses;
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> datasets) {
        return this.delete(datasets, this.deleteAction);
    }

    @Override
    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses deletePermanentlyFromArchive(List<? extends IDatasetLocation> dataSets) {
        return this.delete(dataSets, DeleteAction.DELETE);
    }

    private AbstractArchiverProcessingPlugin.DatasetProcessingStatuses delete(List<? extends IDatasetLocation> datasets, DeleteAction action) {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (IDatasetLocation iDatasetLocation : datasets) {
            Status status = action.execute(this.fileOperationsManager, iDatasetLocation);
            statuses.addResult(iDatasetLocation.getDataSetCode(), status, action.getOperation());
        }
        return statuses;
    }

    @Override
    protected BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        File originalData = this.getDatasetDirectory(context, dataset);
        return this.fileOperationsManager.isSynchronizedWithDestination(originalData, dataset);
    }

    @Override
    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataset) {
        return this.fileOperationsManager.isPresentInDestination(dataset);
    }

    private Status doArchive(DatasetDescription dataset, File originalData) {
        return this.fileOperationsManager.copyToDestination(originalData, dataset);
    }

    private Status doUnarchive(DatasetDescription dataset, File originalData) {
        return this.fileOperationsManager.retrieveFromDestination(originalData, dataset);
    }

    private File getDatasetDirectory(ArchiverTaskContext context, DatasetDescription dataset) {
        return context.getDirectoryProvider().getDataSetDirectory(dataset);
    }

    public static enum ChecksumVerificationCondition {
        NO{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return false;
            }
        }
        ,
        YES{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return true;
            }
        }
        ,
        IF_AVAILABLE{

            @Override
            boolean verifyChecksum(IHierarchicalContentNode node) {
                return node.isChecksumCRC32Precalculated();
            }
        };


        abstract boolean verifyChecksum(IHierarchicalContentNode var1);
    }

    public static enum DeleteAction {
        DELETE(AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE){

            @Override
            public Status execute(IDataSetFileOperationsManager manager, IDatasetLocation dataSet) {
                return manager.deleteFromDestination(dataSet);
            }
        }
        ,
        MARK_AS_DELETED(AbstractArchiverProcessingPlugin.Operation.MARK_AS_DELETED){

            @Override
            public Status execute(IDataSetFileOperationsManager manager, IDatasetLocation dataSet) {
                return manager.markAsDeleted(dataSet);
            }
        };

        private final AbstractArchiverProcessingPlugin.Operation operation;

        private DeleteAction(AbstractArchiverProcessingPlugin.Operation operation) {
            this.operation = operation;
        }

        public AbstractArchiverProcessingPlugin.Operation getOperation() {
            return this.operation;
        }

        public abstract Status execute(IDataSetFileOperationsManager var1, IDatasetLocation var2);
    }
}

