/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class EntityTypePropertyTypeProvider
extends AbstractCommonTableModelProvider<EntityTypePropertyType<?>> {
    protected final EntityType entity;

    public EntityTypePropertyTypeProvider(ICommonServer commonServer, String sessionToken, EntityType entity) {
        super(commonServer, sessionToken);
        this.entity = entity;
    }

    @Override
    protected TypedTableModel<EntityTypePropertyType<?>> createTableModel() {
        List<EntityTypePropertyType<?>> entityTypePropertyTypes = this.commonServer.listEntityTypePropertyTypes(this.sessionToken);
        TypedTableModelBuilder builder = new TypedTableModelBuilder();
        builder.addColumn("ORDINAL").withDefaultWidth(100);
        builder.addColumn("SECTION");
        builder.addColumn("PROPERTY_TYPE_CODE").withDefaultWidth(200);
        builder.addColumn("LABEL").hideByDefault();
        builder.addColumn("DESCRIPTION").hideByDefault();
        builder.addColumn("MODIFICATION_DATE").withDefaultWidth(300).hideByDefault();
        if (this.entity == null) {
            builder.addColumn("ASSIGNED_TO").withDefaultWidth(200);
            builder.addColumn("TYPE_OF");
        }
        builder.addColumn("IS_MANDATORY");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("IS_DYNAMIC");
        builder.addColumn("IS_MANAGED");
        builder.addColumn("IS_SHOWN_IN_EDITOR_VIEW");
        builder.addColumn("SHOW_RAW_VALUE");
        builder.addColumn("SCRIPT");
        for (EntityTypePropertyType<?> etpt : entityTypePropertyTypes) {
            if (this.entity != null && !this.entity.equals(etpt.getEntityType())) continue;
            builder.addRow(etpt);
            PropertyType propertyType = etpt.getPropertyType();
            builder.column("ORDINAL").addInteger(etpt.getOrdinal());
            builder.column("SECTION").addString(etpt.getSection());
            builder.column("PROPERTY_TYPE_CODE").addString(propertyType.getCode());
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("MODIFICATION_DATE").addDate(propertyType.getModificationDate());
            if (this.entity == null) {
                builder.column("ASSIGNED_TO").addString(((Code)etpt.getEntityType()).getCode());
                builder.column("TYPE_OF").addString(etpt.getEntityKind().getDescription());
            }
            builder.column("IS_MANDATORY").addString(SimpleYesNoRenderer.render(etpt.isMandatory()));
            builder.column("DATA_TYPE").addString(EntityTypePropertyTypeProvider.renderDataType(propertyType));
            builder.column("IS_DYNAMIC").addString(SimpleYesNoRenderer.render(etpt.isDynamic()));
            builder.column("IS_MANAGED").addString(SimpleYesNoRenderer.render(etpt.isManaged()));
            builder.column("IS_SHOWN_IN_EDITOR_VIEW").addString(SimpleYesNoRenderer.render(etpt.isShownInEditView()));
            builder.column("SHOW_RAW_VALUE").addString(SimpleYesNoRenderer.render(etpt.getShowRawValue()));
            Script script = etpt.getScript();
            if (script == null) continue;
            builder.column("SCRIPT").addString(script.getName());
        }
        return builder.getModel();
    }

    protected static String renderDataType(PropertyType entity) {
        DataTypeCode dataType = entity.getDataType().getCode();
        switch (dataType) {
            case BOOLEAN: {
                return "True / False";
            }
            case CONTROLLEDVOCABULARY: {
                return "Vocabulary: " + EntityTypePropertyTypeProvider.tryGetVocabularyCode(entity);
            }
            case INTEGER: {
                return "Integer Number";
            }
            case MATERIAL: {
                String materialTypeCode = EntityTypePropertyTypeProvider.tryGetMaterialTypeCode(entity);
                if (materialTypeCode == null) {
                    return "Material of Any Type";
                }
                return "Material of Type: " + materialTypeCode;
            }
            case REAL: {
                return "Float Number";
            }
            case TIMESTAMP: {
                return "Date and Time";
            }
            case VARCHAR: {
                return "Text";
            }
        }
        return dataType.name();
    }

    protected static String tryGetVocabularyCode(PropertyType entity) {
        Vocabulary vocabulary = entity.getVocabulary();
        return vocabulary != null ? vocabulary.getCode() : null;
    }

    protected static String tryGetMaterialTypeCode(PropertyType entity) {
        MaterialType materialType = entity.getMaterialType();
        return materialType != null ? materialType.getCode() : null;
    }
}

