/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.IOpenBisSessionManager;
import ch.systemsx.cisd.openbis.generic.shared.dto.AuthorizationGroupPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RoleAssignmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import java.io.Serializable;
import org.hibernate.EmptyInterceptor;
import org.hibernate.Transaction;
import org.hibernate.type.Type;

public class SessionsUpdateInterceptor
extends EmptyInterceptor {
    private static final long serialVersionUID = 35L;
    private IOpenBisSessionManager openBisSessionManager;
    private IDAOFactory daoFactory;
    private boolean sessionsUpdateNeeded;

    public SessionsUpdateInterceptor(IOpenBisSessionManager openBisSessionManager, IDAOFactory daoFactory) {
        this.openBisSessionManager = openBisSessionManager;
        this.daoFactory = daoFactory;
    }

    public boolean onFlushDirty(Object entity, Serializable id, Object[] currentState, Object[] previousState, String[] propertyNames, Type[] types) {
        this.checkAuthorizationEntity(entity);
        return false;
    }

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.checkAuthorizationEntity(entity);
        this.checkSpace(entity);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.checkAuthorizationEntity(entity);
        return false;
    }

    private void checkAuthorizationEntity(Object entity) {
        if (entity instanceof RoleAssignmentPE || entity instanceof AuthorizationGroupPE) {
            this.sessionsUpdateNeeded = true;
        }
    }

    private void checkSpace(Object entity) {
        if (entity instanceof SpacePE) {
            this.sessionsUpdateNeeded = true;
        }
    }

    public void afterTransactionCompletion(Transaction tx) {
        if (this.sessionsUpdateNeeded && tx.wasCommitted()) {
            this.openBisSessionManager.updateAllSessions();
        }
    }
}

