/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class DataSetRegistrationSummaryTask
implements IMaintenanceTask {
    public static final String DAYS_OF_WEEK_KEY = "days-of-week";
    public static final String DAYS_OF_MONTH_KEY = "days-of-month";
    public static final String DATE_RANGE_START_KEY = "date-range-start";
    public static final String DATE_RANGE_STOP_KEY = "date-range-stop";
    public static final String DATA_SET_TYPES = "data-set-types";
    public static final String CONFIGURED_CONTENT = "configured-content";
    public static final String SHOWN_DATA_SET_PROPERTIES_KEY = "shown-data-set-properties";
    public static final String EMAIL_ADDRESSES_KEY = "email-addresses";
    private static final String SEPARATOR = ",";
    private static final int NUMBER_OF_DATA_SET_CODES_PER_LINE = 4;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final Template SUBJECT_TEMPLATE = new Template("New data sets registered between ${from-date} and ${until-date}");
    private static final Template REPORT_TEMPLATE = new Template("Dear user\n\nThis report summarizes data sets registered in openBIS between ${from-date} and ${until-date}.\n\n${configured-content}\n\n${data-sets}\n\nRegards,\nopenBIS");
    private static final Template NO_NEW_DATA_SETS_TEMPLATE = new Template("${data-set-type}: Total number: ${total-number}. No new data sets.\n");
    private static final Template NEW_DATA_SETS_TEMPLATE = new Template("${data-set-type}: Total number: ${total-number}. Number of new data sets: ${number-of-new-data-sets}\n${new-data-sets}");
    private static final Template NEW_DATA_SET_TEMPLATE = new Template("\t${data-set-code}\n");
    private static final Template NEW_DATA_SET_WITH_PROPERTIES_TEMPLATE = new Template("\t${data-set-code}: ${properties}\n");
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetRegistrationSummaryTask.class);
    private ICommonServerForInternalUse server;
    private ITimeProvider timeProvider;
    private IMailClient mailClient;
    private Set<Integer> daysOfWeek;
    private Set<Integer> daysOfMonth;
    private Set<String> dataSetTypeCodes;
    private List<String> shownProperties;
    private List<EMailAddress> emailAddresses;
    private String configuredContent;

    public DataSetRegistrationSummaryTask() {
        this(CommonServiceProvider.getCommonServer(), SystemTimeProvider.SYSTEM_TIME_PROVIDER, CommonServiceProvider.createEMailClient());
    }

    DataSetRegistrationSummaryTask(ICommonServerForInternalUse server, ITimeProvider timeProvider, IMailClient mailClient) {
        this.server = server;
        this.timeProvider = timeProvider;
        this.mailClient = mailClient;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.daysOfWeek = this.extractDays(properties, DAYS_OF_WEEK_KEY, "");
        this.daysOfMonth = this.extractDays(properties, DAYS_OF_MONTH_KEY, "1");
        this.shownProperties = this.getAsList(properties, SHOWN_DATA_SET_PROPERTIES_KEY);
        this.emailAddresses = this.getEMailAddresses(properties);
        this.dataSetTypeCodes = this.extractDataSetTypeCodes(properties, DATA_SET_TYPES);
        this.configuredContent = PropertyUtils.getProperty(properties, CONFIGURED_CONTENT, "The data sets are grouped by type.");
        operationLog.info((Object)("Task " + pluginName + " initialized."));
    }

    private List<EMailAddress> getEMailAddresses(Properties properties) {
        String[] tokens = PropertyUtils.getMandatoryProperty(properties, EMAIL_ADDRESSES_KEY).split(SEPARATOR);
        ArrayList<EMailAddress> addresses = new ArrayList<EMailAddress>();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            addresses.add(new EMailAddress(token.trim()));
            ++n2;
        }
        return addresses;
    }

    private Set<String> extractDataSetTypeCodes(Properties properties, String key) {
        HashSet<String> result = new HashSet<String>();
        String property = properties.getProperty(key, "").trim();
        if (property.length() > 0) {
            String[] stringArray = property.split(SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String dataSetTypeCode = stringArray[n2];
                result.add(dataSetTypeCode.trim());
                ++n2;
            }
        }
        return result;
    }

    private Set<Integer> extractDays(Properties properties, String key, String defaultValue) {
        HashSet<Integer> result = new HashSet<Integer>();
        String property = properties.getProperty(key, defaultValue).trim();
        if (property.length() > 0) {
            String[] stringArray = property.split(SEPARATOR);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String day = stringArray[n2];
                try {
                    result.add(new Integer(day.trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Property '" + key + "' is not a list of numbers separated by commas: " + property);
                }
                ++n2;
            }
        }
        return result;
    }

    private List<String> getAsList(Properties properties, String key) {
        List<String> list = PropertyUtils.tryGetList(properties, key);
        if (list == null || list.size() == 1 && list.get(0).length() == 0) {
            return Collections.emptyList();
        }
        return list;
    }

    @Override
    public void execute() {
        if (!this.isDay()) {
            return;
        }
        SessionContextDTO contextOrNull = this.server.tryToAuthenticateAsSystem();
        if (contextOrNull == null) {
            return;
        }
        long startTime = this.getStart();
        long endTime = this.getEnd();
        String sessionToken = contextOrNull.getSessionToken();
        String dataSetsAsString = this.loadAndRenderDataSets(sessionToken, startTime, endTime);
        String fromDate = DATE_FORMAT.format(new Date(startTime));
        String untilDate = DATE_FORMAT.format(new Date(endTime));
        Template subjectTemplate = SUBJECT_TEMPLATE.createFreshCopy();
        subjectTemplate.bind("from-date", fromDate);
        subjectTemplate.bind("until-date", untilDate);
        String subject = subjectTemplate.createText();
        Template template = REPORT_TEMPLATE.createFreshCopy();
        template.bind("from-date", fromDate);
        template.bind("until-date", untilDate);
        template.bind("data-sets", dataSetsAsString);
        template.bind(CONFIGURED_CONTENT, this.configuredContent);
        String report = template.createText();
        for (EMailAddress address : this.emailAddresses) {
            this.mailClient.sendEmailMessage(subject, report, null, null, address);
        }
        operationLog.info((Object)("Data set registration report for period from " + fromDate + " until " + untilDate + " created and sent."));
    }

    private String loadAndRenderDataSets(String sessionToken, long startTime, long endTime) {
        List<DataSetType> dataSetTypes = this.getAllDataSetTypes(sessionToken);
        StringBuilder builder = new StringBuilder();
        for (DataSetType dataSetType : dataSetTypes) {
            if (this.excludeDataSetType(dataSetType)) continue;
            DetailedSearchCriteria criteria = new DetailedSearchCriteria();
            criteria.setConnection(SearchCriteriaConnection.MATCH_ALL);
            criteria.setUseWildcardSearchMode(true);
            DetailedSearchCriterion criterion = new DetailedSearchCriterion();
            criterion.setField(DetailedSearchField.createAttributeField(DataSetAttributeSearchFieldKind.DATA_SET_TYPE));
            criterion.setValue(dataSetType.getCode());
            criteria.setCriteria(Arrays.asList(criterion));
            List<AbstractExternalData> dataSets = this.server.searchForDataSets(sessionToken, criteria);
            ArrayList<AbstractExternalData> newDataSets = new ArrayList<AbstractExternalData>();
            for (AbstractExternalData dataSet : dataSets) {
                long registrationTime = dataSet.getRegistrationDate().getTime();
                if (startTime > registrationTime || registrationTime >= endTime) continue;
                newDataSets.add(dataSet);
            }
            Collections.sort(newDataSets, new Comparator<AbstractExternalData>(){

                @Override
                public int compare(AbstractExternalData d1, AbstractExternalData d2) {
                    return d1.getCode().compareTo(d2.getCode());
                }
            });
            builder.append(this.createReport(dataSetType, newDataSets, dataSets.size()));
        }
        String dataSetsAsString = builder.toString();
        return dataSetsAsString;
    }

    private boolean excludeDataSetType(DataSetType dataSetType) {
        boolean includeDataSetType = this.dataSetTypeCodes.isEmpty() ? true : this.dataSetTypeCodes.contains(dataSetType.getCode());
        return !includeDataSetType;
    }

    private String createReport(DataSetType dataSetType, List<AbstractExternalData> newDataSets, int totalNumberOfDataSets) {
        Template template = (newDataSets.isEmpty() ? NO_NEW_DATA_SETS_TEMPLATE : NEW_DATA_SETS_TEMPLATE).createFreshCopy();
        template.bind("data-set-type", dataSetType.getCode());
        template.bind("total-number", Integer.toString(totalNumberOfDataSets));
        template.attemptToBind("number-of-new-data-sets", Integer.toString(newDataSets.size()));
        template.attemptToBind("new-data-sets", this.renderNewDataSets(newDataSets));
        return template.createText();
    }

    private String renderNewDataSets(List<AbstractExternalData> newDataSets) {
        StringBuilder builder = new StringBuilder();
        if (this.shownProperties.isEmpty()) {
            int i = 0;
            int n = newDataSets.size();
            while (i < n) {
                if (i % 4 == 0) {
                    builder.append("\t");
                }
                AbstractExternalData dataSet = newDataSets.get(i);
                builder.append(dataSet.getCode());
                if (i < n - 1) {
                    builder.append(", ");
                }
                if ((i + 1) % 4 == 0 || i == n - 1) {
                    builder.append("\n");
                }
                ++i;
            }
        } else {
            Template noPropertiesTemplate = NEW_DATA_SET_TEMPLATE.createFreshCopy();
            Template withPropertiesTemplate = NEW_DATA_SET_WITH_PROPERTIES_TEMPLATE.createFreshCopy();
            for (AbstractExternalData dataSet : newDataSets) {
                String code = dataSet.getCode();
                String propertiesToBeShown = this.getPropertiesToBeShown(dataSet);
                Template t = propertiesToBeShown.length() == 0 ? noPropertiesTemplate : withPropertiesTemplate;
                t.attemptToBind("data-set-code", code);
                t.attemptToBind("properties", propertiesToBeShown);
                builder.append(t.createText());
            }
        }
        return builder.toString();
    }

    private String getPropertiesToBeShown(AbstractExternalData dataSet) {
        StringBuilder builder = new StringBuilder();
        Map<String, String> map = this.getPropertiesAsAMap(dataSet);
        for (String key : this.shownProperties) {
            String value = map.get(key);
            if (value == null) continue;
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(key).append(" = ").append(value);
        }
        return builder.toString();
    }

    private Map<String, String> getPropertiesAsAMap(AbstractExternalData dataSet) {
        List<IEntityProperty> dataSetProperties = dataSet.getProperties();
        HashMap<String, String> map = new HashMap<String, String>(dataSetProperties.size());
        for (IEntityProperty property : dataSetProperties) {
            map.put(property.getPropertyType().getCode(), property.tryGetAsString());
        }
        return map;
    }

    private List<DataSetType> getAllDataSetTypes(String sessionToken) {
        List<DataSetType> dataSetTypes = this.server.listDataSetTypes(sessionToken);
        Collections.sort(dataSetTypes, new Comparator<DataSetType>(){

            @Override
            public int compare(DataSetType t1, DataSetType t2) {
                return t1.getCode().compareTo(t2.getCode());
            }
        });
        return dataSetTypes;
    }

    private boolean isDay() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timeProvider.getTimeInMilliseconds());
        return this.isDay(calendar);
    }

    private long getStart() {
        long time = this.timeProvider.getTimeInMilliseconds();
        Calendar calendar = Calendar.getInstance();
        do {
            calendar.setTimeInMillis(time -= 86400000L);
        } while (!this.isDay(calendar));
        return this.getFirstMilliSecondOfTheDay(calendar);
    }

    private long getEnd() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.timeProvider.getTimeInMilliseconds());
        return calendar.getTimeInMillis();
    }

    private boolean isDay(Calendar calendar) {
        return this.daysOfWeek.contains(calendar.get(7)) || this.daysOfMonth.contains(calendar.get(5));
    }

    private long getFirstMilliSecondOfTheDay(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }
}

