/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.AbstractTabItemFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DispatcherHelper;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.DisposableEntityChooser;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ICellListenerAndLinkGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.IDataRefreshCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IMessageProvider;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.PhosphoNetXDisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinByExperimentBrowerToolBar;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinSummaryGrid;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinViewLocatorResolver;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinViewer;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.dto.ListProteinByExperimentCriteria;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AbundanceColumnDefinition;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.AggregateFunction;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.ProteinInfo;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.TabPanel;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.extjs.gxt.ui.client.widget.layout.RowData;
import com.extjs.gxt.ui.client.widget.layout.RowLayout;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

class ProteinByExperimentBrowserGrid
extends TypedTableGrid<ProteinInfo> {
    private static final String PREFIX = "openbis_protein-by-experiment-browser";
    public static final String BROWSER_ID = "openbis_protein-by-experiment-browser_main";
    public static final String GRID_ID = "openbis_protein-by-experiment-browser-grid";
    private final IViewContext<IPhosphoNetXClientServiceAsync> specificViewContext;
    private final ProteinByExperimentBrowerToolBar toolbar;
    private ListProteinByExperimentCriteria criteria;
    private IDataRefreshCallback postRefreshCallback = new IDataRefreshCallback(){

        @Override
        public void postRefresh(boolean wasSuccessful) {
        }
    };

    static IDisposableComponent create(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, BasicEntityType experimentType, Experiment experiment) {
        final IDisposableComponent summaryGrid = ProteinSummaryGrid.create(viewContext);
        ProteinByExperimentBrowserGrid browserGrid = new ProteinByExperimentBrowserGrid(viewContext, experiment);
        final DisposableEntityChooser disposableBrowerGrid = browserGrid.asDisposableWithoutToolbar();
        ProteinByExperimentBrowerToolBar toolBar = browserGrid.toolbar;
        toolBar.setSummaryGrid((ProteinSummaryGrid)summaryGrid.getComponent());
        final LayoutContainer container = new LayoutContainer();
        container.setLayout((Layout)new RowLayout());
        container.add((Widget)toolBar);
        TabPanel tabPanel = new TabPanel();
        tabPanel.add(ProteinByExperimentBrowserGrid.createTab(disposableBrowerGrid, viewContext, "protein_browser"));
        tabPanel.add(ProteinByExperimentBrowserGrid.createTab(summaryGrid, viewContext, "protein_summary"));
        container.add((Widget)tabPanel, (LayoutData)new RowData(1.0, 1.0));
        toolBar.update();
        return new IDisposableComponent(){

            @Override
            public void update(Set<DatabaseModificationKind> observedModifications) {
                disposableBrowerGrid.update(observedModifications);
                summaryGrid.update(observedModifications);
            }

            @Override
            public DatabaseModificationKind[] getRelevantModifications() {
                return disposableBrowerGrid.getRelevantModifications();
            }

            @Override
            public Component getComponent() {
                return container;
            }

            @Override
            public void dispose() {
                disposableBrowerGrid.dispose();
                summaryGrid.dispose();
            }
        };
    }

    private static TabItem createTab(IDisposableComponent disposableComponent, IMessageProvider messageProvider, String titleKey) {
        TabItem tabItem = new TabItem(messageProvider.getMessage(titleKey, new Object[0]));
        tabItem.setLayout((Layout)new FitLayout());
        Component component = disposableComponent.getComponent();
        component.setHeight("100%");
        tabItem.add((Widget)component);
        return tabItem;
    }

    private ProteinByExperimentBrowserGrid(final IViewContext<IPhosphoNetXClientServiceAsync> viewContext, final Experiment experiment) {
        super(viewContext.getCommonViewContext(), BROWSER_ID, true, PhosphoNetXDisplayTypeIDGenerator.PROTEIN_BY_EXPERIMENT_BROWSER_GRID);
        this.specificViewContext = viewContext;
        this.toolbar = new ProteinByExperimentBrowerToolBar(viewContext, experiment);
        this.toolbar.setBrowserGrid(this);
        this.registerListenerAndLinkGenerator("ACCESSION_NUMBER", new ICellListenerAndLinkGenerator<ProteinInfo>(){

            @Override
            public void handle(TableModelRowWithObject<ProteinInfo> rowItem, boolean keyPressed) {
                AbstractTabItemFactory tabItemFactory = ProteinViewer.createTabItemFactory(viewContext, ProteinByExperimentBrowserGrid.this.toolbar.getExperimentOrNull(), rowItem.getObjectOrNull());
                tabItemFactory.setInBackground(keyPressed);
                DispatcherHelper.dispatchNaviEvent(tabItemFactory);
            }

            @Override
            public String tryGetLink(ProteinInfo entity, ISerializableComparable comparableValue) {
                return ProteinViewLocatorResolver.createLink(experiment, entity);
            }
        });
    }

    void update(TechId experimentID, double falseDiscoveryRate, AggregateFunction aggregateFunction, String treatmentTypeCode, boolean aggregateOriginal, List<AbundanceColumnDefinition> definitions) {
        this.criteria = new ListProteinByExperimentCriteria();
        this.criteria.setExperimentID(experimentID);
        this.criteria.setFalseDiscoveryRate(falseDiscoveryRate);
        this.criteria.setAggregateFunction(aggregateFunction);
        this.criteria.setTreatmentTypeCode(treatmentTypeCode);
        this.criteria.setAggregateOriginal(aggregateOriginal);
        this.refresh(this.postRefreshCallback, true);
    }

    void setPostRefreshCallback(IDataRefreshCallback postRefreshCallback) {
        this.postRefreshCallback = postRefreshCallback;
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("PROTEIN_DESCRIPTION");
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<ProteinInfo>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<ProteinInfo>> callback) {
        if (this.criteria == null) {
            this.criteria = this.toolbar.getCriteria();
        }
        this.criteria.copyPagingConfig(resultSetConfig);
        this.specificViewContext.getService().listProteinsByExperiment(this.criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<ProteinInfo>> exportCriteria, AbstractAsyncCallback<String> callback) {
        this.specificViewContext.getService().prepareExportProteins(exportCriteria, callback);
    }

    @Override
    public void update(Set<DatabaseModificationKind> observedModifications) {
        this.toolbar.update();
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return new DatabaseModificationKind[]{DatabaseModificationKind.createOrDelete(DatabaseModificationKind.ObjectKind.DATA_SET), DatabaseModificationKind.edit(DatabaseModificationKind.ObjectKind.SAMPLE)};
    }
}

