/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.client.web.client.application.detailviewers;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.LabeledItem;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.SimpleModelComboBox;
import ch.systemsx.cisd.openbis.plugin.screening.client.web.client.IScreeningClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import java.util.Collections;
import java.util.List;

public class ResolutionChooser
extends LayoutContainer {
    private SimpleModelComboBox<ImageResolution> comboBox;

    public ResolutionChooser(IViewContext<IScreeningClientServiceAsync> viewContext, List<ImageResolution> resolutions, ImageResolution defaultResolution) {
        LabeledItem<ImageResolution> defaultResolutionItem;
        List defaultItems = Collections.singletonList(new LabeledItem<Object>(null, viewContext.getMessage("RESOLUTION_CHOOSER_DEFAULT", new Object[0])));
        this.comboBox = new SimpleModelComboBox(viewContext, defaultItems, null);
        Collections.sort(resolutions);
        if (resolutions != null) {
            for (ImageResolution resolution : resolutions) {
                String resolutionText = viewContext.getMessage("RESOLUTION_CHOOSER_RESOLUTION", resolution.getWidth(), resolution.getHeight());
                this.comboBox.add(new LabeledItem<ImageResolution>(resolution, resolutionText));
            }
        }
        if ((defaultResolutionItem = this.comboBox.findModelForVal(defaultResolution)) != null) {
            this.comboBox.setSelection(defaultResolutionItem);
        }
        this.add((Component)this.comboBox);
    }

    public ImageResolution getResolution() {
        return this.comboBox.tryGetChosenItem();
    }

    public void addResolutionChangedListener(Listener<BaseEvent> listener) {
        this.comboBox.addListener(Events.SelectionChange, listener);
    }
}

