/*
 * Decompiled with CFR 0.152.
 */
package eu.basynthec.cisd.dss;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.ExcelFileReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Workbook;

public class TimeSeriesDataExcel {
    private static final String OPENBIS_METADATA_SHEET_NAME = "openbis-metadata";
    private static final String OPENBIS_DATA_SHEET_NAME = "openbis-data";
    private static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, TimeSeriesDataExcel.class);
    private final File file;
    private final ExcelFileReader fileReader;

    public static TimeSeriesDataExcel createTimeSeriesDataExcel(String fileName) {
        File file = new File(fileName);
        try {
            Workbook workbook = ExcelFileReader.getExcelWorkbook((File)file);
            ExcelFileReader fileReader = new ExcelFileReader(workbook, true);
            return new TimeSeriesDataExcel(file, fileReader);
        }
        catch (IllegalArgumentException ex) {
            operationLog.error((Object)("Could not open file [" + fileName + "] as Excel data."), (Throwable)ex);
        }
        catch (IOException ex) {
            operationLog.error((Object)("Could not open file [" + fileName + "] as Excel data."), (Throwable)ex);
        }
        return null;
    }

    private TimeSeriesDataExcel(File file, ExcelFileReader fileReader) {
        this.file = file;
        this.fileReader = fileReader;
    }

    public List<String[]> getRawMetadataLines() {
        try {
            return this.fileReader.readLines(OPENBIS_METADATA_SHEET_NAME);
        }
        catch (IOException ex) {
            operationLog.error((Object)("Could not read data from [file: " + this.file.getPath() + ", sheet: " + OPENBIS_METADATA_SHEET_NAME + "]"), (Throwable)ex);
            return new ArrayList<String[]>();
        }
    }

    public List<String[]> getRawDataLines() {
        try {
            return this.fileReader.readLines(OPENBIS_DATA_SHEET_NAME);
        }
        catch (IOException ex) {
            operationLog.error((Object)("Could not read data from [file: " + this.file.getPath() + ", sheet: " + OPENBIS_DATA_SHEET_NAME + "]"), (Throwable)ex);
            return new ArrayList<String[]>();
        }
    }

    public Map<String, String> getMetadataMap() {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        List<String[]> metadataLines = this.getRawMetadataLines();
        int i = 1;
        while (i < metadataLines.size()) {
            String[] line = metadataLines.get(i);
            String key = line[0];
            if (key != null) {
                String value = line[1];
                if ("BLANK".equals(value)) {
                    value = null;
                }
                metadataMap.put(line[0].toUpperCase(), value);
            }
            ++i;
        }
        return metadataMap;
    }
}

