/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.etlserver.utils.Column;
import eu.basysbio.cisd.dss.AbstractColumnInjection;
import eu.basysbio.cisd.dss.ChipChipData;
import eu.basysbio.cisd.dss.IColumnInjection;
import eu.basysbio.cisd.dss.IInjectionFactory;
import java.util.List;
import org.apache.commons.lang.StringUtils;

enum ChipChipInjectionFactory implements IInjectionFactory<ChipChipData>
{
    BSU_IDENTIFIER(1){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setBsuIdentifier(value);
                }
            };
        }
    }
    ,
    GENE_NAME(2){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setGeneName(value);
                }
            };
        }
    }
    ,
    GENE_FUNCTION(3){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setGeneFunction(value);
                }
            };
        }
    }
    ,
    ARRAY_DESIGN(4){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setArrayDesign(value);
                }
            };
        }
    }
    ,
    MICRO_ARRAY_ID(5){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    Integer number = null;
                    if (StringUtils.isNotBlank((String)value)) {
                        number = Integer.parseInt(value);
                    }
                    dataValue.setMicroArrayID(number);
                }
            };
        }
    }
    ,
    INTERGENIC(9){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setIntergenic("true".equalsIgnoreCase(value));
                }
            };
        }
    }
    ,
    NEARBY_GENE_NAMES(10){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setNearbyGeneNames(value);
                }
            };
        }
    }
    ,
    NEARBY_GENE_IDS(11){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setNearbyGeneIDs(value);
                }
            };
        }
    }
    ,
    DISTANCE_FROM_START(12){

        @Override
        public IColumnInjection<ChipChipData> create(Column column) {
            return new AbstractColumnInjection<ChipChipData>(column){

                @Override
                void inject(ChipChipData dataValue, String value) {
                    dataValue.setDistancesFromStart(value);
                }
            };
        }
    };

    private final int columnNumber;

    private ChipChipInjectionFactory(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    @Override
    public IColumnInjection<ChipChipData> tryToCreate(List<Column> columns) {
        int colIndex = this.columnNumber - 1;
        if (colIndex >= columns.size()) {
            return null;
        }
        Column column = columns.get(colIndex);
        return this.create(column);
    }

    public abstract IColumnInjection<ChipChipData> create(Column var1);

    /* synthetic */ ChipChipInjectionFactory(String string, int n, int n2, ChipChipInjectionFactory chipChipInjectionFactory) {
        this(n2);
    }
}

