/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.cifex.CifexDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.cifex.CifexTypeExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import eu.basysbio.cisd.dss.DataSetPropertiesExtractor;
import eu.basysbio.cisd.dss.IDataSetPropertiesExtractor;
import eu.basysbio.cisd.dss.LcaMicDataSetPropertiesExtractor;
import eu.basysbio.cisd.dss.TimeSeriesPropertyType;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DataSetInfoExtractor
implements IDataSetInfoExtractor {
    private final CifexDataSetInfoExtractor infoExtractor;
    private final CifexTypeExtractor typeExtractor;
    private final Map<String, IDataSetPropertiesExtractor> propertiesExtractors = new HashMap<String, IDataSetPropertiesExtractor>();
    private IDataSetPropertiesExtractor defaultExtractor;

    public DataSetInfoExtractor(Properties properties) {
        this.infoExtractor = new CifexDataSetInfoExtractor(properties);
        this.typeExtractor = new CifexTypeExtractor(properties);
        this.defaultExtractor = new DataSetPropertiesExtractor(properties, true);
        DataSetPropertiesExtractor timeSeriesExtractor = new DataSetPropertiesExtractor(properties, false);
        this.propertiesExtractors.put("TIME_SERIES", timeSeriesExtractor);
        this.propertiesExtractors.put("LCA_MTP_TIME_SERIES", timeSeriesExtractor);
        this.propertiesExtractors.put("LCA_MTP_PCAV_TIME_SERIES", timeSeriesExtractor);
        this.propertiesExtractors.put("LCA_MIC_TIME_SERIES", timeSeriesExtractor);
        this.propertiesExtractors.put("LCA_MIC", new LcaMicDataSetPropertiesExtractor(properties));
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        DataSetType dataSetType;
        IDataSetPropertiesExtractor extractor;
        DataSetInformation info = this.infoExtractor.getDataSetInformation(incomingDataSetPath, openbisService);
        String email = info.tryGetUploadingUserEmail();
        if (email != null) {
            info.getDataSetProperties().add(new NewProperty(TimeSeriesPropertyType.UPLOADER_EMAIL.toString(), email));
        }
        if ((extractor = this.propertiesExtractors.get((dataSetType = this.typeExtractor.getDataSetType(incomingDataSetPath)).getCode())) == null) {
            extractor = this.defaultExtractor;
        }
        List<NewProperty> headerProperties = extractor.extractDataSetProperties(incomingDataSetPath);
        info.getDataSetProperties().addAll(headerProperties);
        return info;
    }
}

