/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.base.io.IOutputStream;
import ch.systemsx.cisd.base.utilities.OSUtilities;
import ch.systemsx.cisd.etlserver.utils.Column;
import java.util.ArrayList;
import java.util.List;

class TSVOutputWriter {
    private final IOutputStream outputStream;

    TSVOutputWriter(IOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    void write(List<Column> columns) {
        Printer printer = new Printer(this.outputStream);
        ArrayList<List> cols = new ArrayList<List>();
        int numberOfRows = Integer.MAX_VALUE;
        String delim = "";
        for (Column column : columns) {
            printer.print(String.valueOf(delim) + column.getHeader());
            delim = "\t";
            List values = column.getValues();
            numberOfRows = Math.min(numberOfRows, values.size());
            cols.add(values);
        }
        printer.println("");
        int i = 0;
        while (i < numberOfRows) {
            delim = "";
            for (List col : cols) {
                printer.print(String.valueOf(delim) + (String)col.get(i));
                delim = "\t";
            }
            printer.println("");
            ++i;
        }
        this.outputStream.flush();
    }

    void close() {
        this.outputStream.close();
    }

    private static final class Printer {
        private final IOutputStream outputStream;

        public Printer(IOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        public void println(Object object) {
            this.print(object + OSUtilities.LINE_SEPARATOR);
        }

        public void print(Object object) {
            this.outputStream.write(String.valueOf(object).getBytes());
        }
    }
}

