/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.properties.PropertyUtils;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.regex.Pattern;

class TimeSeriesDataSetUploaderParameters {
    static final String DATA_SET_TYPE_PATTERN_FOR_DEFAULT_HANDLING = "data-set-type-pattern-for-default-handling";
    static final String EXPERIMENT_CODE_TEMPLATE_KEY = "experiment-code-template";
    static final String DEFAULT_EXPERIMENT_CODE_TEMPLATE = "{0}_{1}_{2}";
    static final String IGNORE_EMPTY_LINES_KEY = "ignore-empty-lines";
    private final MessageFormat experimentCodeFormat;
    private final boolean ignoreEmptyLines;
    private final Pattern patternForDefaultHandling;

    TimeSeriesDataSetUploaderParameters(Properties properties) {
        this.patternForDefaultHandling = Pattern.compile(PropertyUtils.getMandatoryProperty((Properties)properties, (String)DATA_SET_TYPE_PATTERN_FOR_DEFAULT_HANDLING));
        this.ignoreEmptyLines = PropertyUtils.getBoolean((Properties)properties, (String)IGNORE_EMPTY_LINES_KEY, (boolean)false);
        this.experimentCodeFormat = new MessageFormat(properties.getProperty(EXPERIMENT_CODE_TEMPLATE_KEY, DEFAULT_EXPERIMENT_CODE_TEMPLATE));
    }

    MessageFormat getExperimentCodeFormat() {
        return this.experimentCodeFormat;
    }

    boolean isIgnoreEmptyLines() {
        return this.ignoreEmptyLines;
    }

    Pattern getPatternForDefaultHandling() {
        return this.patternForDefaultHandling;
    }
}

